/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.MergeOperation;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizardAdvancedPage;
import com.collabnet.subversion.merge.wizards.MergeWizardLastPage;
import com.collabnet.subversion.merge.wizards.MergeWizardMainPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class AdvancedMergeInputProvider
implements IMergeInputProvider {
    private String text;
    private String description;
    private Image image;
    private int sequence;
    private MergeWizardAdvancedPage advancedPage;
    private WizardPage[] wizardPages;

    public String getText() {
        return this.text;
    }

    public int getSequence() {
        return this.sequence;
    }

    public IWizardPage[] getWizardPages(boolean initializePages) {
        if (this.wizardPages == null || initializePages) {
            this.advancedPage = new MergeWizardAdvancedPage("advanced", Messages.AdvancedMergeInputProvider_selectMergeSource, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"));
            WizardPage[] pages = new WizardPage[]{this.advancedPage};
            this.wizardPages = pages;
        }
        return this.wizardPages;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        return null;
    }

    public boolean performMerge(MergeWizardMainPage mainPage, MergeWizardLastPage optionsPage, IWorkbenchPart targetPart) {
        IResource[] resources = this.advancedPage.getResources();
        MergeOperation mergeOperation = new MergeOperation(targetPart, resources, this.advancedPage.getFromUrls(), this.advancedPage.getFromRevision(), this.advancedPage.getToUrls(), this.advancedPage.getToRevision(), null, null);
        mergeOperation.setForce(optionsPage.isForce());
        mergeOperation.setIgnoreAncestry(optionsPage.isIgnore());
        mergeOperation.setDepth(optionsPage.getDepth());
        mergeOperation.setTextConflictHandling(optionsPage.getTextConflictHandling());
        mergeOperation.setBinaryConflictHandling(optionsPage.getBinaryConflictHandling());
        mergeOperation.setPropertyConflictHandling(optionsPage.getPropertyConflictHandling());
        try {
            mergeOperation.run();
        }
        catch (Exception e) {
            Activator.handleError(Messages.AdvancedMergeInputProvider_error, e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AdvancedMergeInputProvider_merge, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int compareTo(Object compareToObject) {
        if (!(compareToObject instanceof IMergeInputProvider)) {
            return 0;
        }
        IMergeInputProvider compareToInputProvider = (IMergeInputProvider)compareToObject;
        if (this.getSequence() > compareToInputProvider.getSequence()) {
            return 1;
        }
        if (compareToInputProvider.getSequence() > this.getSequence()) {
            return -1;
        }
        return this.getText().compareTo(compareToInputProvider.getText());
    }

    public boolean enabledForMultipleSelection() {
        return false;
    }

    public boolean showOptionsPage() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hideDepth() {
        return false;
    }

    public boolean hideForce() {
        return false;
    }

    public boolean hideIgnoreAncestry() {
        return false;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public boolean showBestPracticesPage() {
        return true;
    }
}

