/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.extensions.HgTransplantClient;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.TransplantOptionsPage;
import com.vectrace.MercurialEclipse.wizards.TransplantPage;
import java.net.URISyntaxException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TransplantWizard
extends HgWizard {
    private IProject project;

    public TransplantWizard(IResource resource) {
        super(Messages.getString("TransplantWizard.title"));
        this.setNeedsProgressMonitor(true);
        this.project = resource.getProject();
    }

    public void addPages() {
        super.addPages();
        TransplantPage transplantPage = new TransplantPage(Messages.getString("TransplantWizard.transplantPage.name"), Messages.getString("TransplantWizard.transplantPage.title"), null, this.project);
        this.initPage(Messages.getString("TransplantWizard.transplantPage.description"), transplantPage);
        transplantPage.setShowCredentials(true);
        this.page = transplantPage;
        this.addPage((IWizardPage)this.page);
        TransplantOptionsPage optionsPage = new TransplantOptionsPage(Messages.getString("TransplantWizard.optionsPage.name"), Messages.getString("TransplantWizard.optionsPage.title"), null, this.project);
        this.initPage(Messages.getString("TransplantWizard.optionsPage.description"), optionsPage);
        this.addPage((IWizardPage)optionsPage);
    }

    public boolean performFinish() {
        HgRepositoryLocation repo;
        block5: {
            this.page.finish((IProgressMonitor)new NullProgressMonitor());
            Properties props = this.page.getProperties();
            repo = MercurialEclipsePlugin.getRepoManager().fromProperties(props);
            if (this.project.getLocation() != null) break block5;
            String msg = String.valueOf(Messages.getString("PushRepoWizard.project")) + this.project.getName() + Messages.getString("PushRepoWizard.notExists");
            MercurialEclipsePlugin.logError(msg, null);
            return false;
        }
        try {
            TransplantPage transplantPage = (TransplantPage)this.page;
            TransplantOptionsPage optionsPage = (TransplantOptionsPage)this.page.getNextPage();
            String result = HgTransplantClient.transplant(this.project, transplantPage.getNodeIds(), repo, transplantPage.isBranch(), transplantPage.getBranchName(), transplantPage.isAll(), optionsPage.isMerge(), optionsPage.getMergeNodeId(), optionsPage.isPrune(), optionsPage.getPruneNodeId(), optionsPage.isContinueLastTransplant(), optionsPage.isFilterChangesets(), optionsPage.getFilter());
            if (result.length() != 0) {
                HgClients.getConsole().printMessage(result, null);
            }
            MercurialEclipsePlugin.getRepoManager().addRepoLocation(this.project, repo);
        }
        catch (URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("PushRepoWizard.malformedUrl"), (String)e.getMessage());
            return false;
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)e.getMessage(), (String)e.getMessage());
            return false;
        }
        return true;
    }
}

