/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgPushPullClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgSvnClient;
import com.vectrace.MercurialEclipse.commands.extensions.forest.HgFpushPullClient;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.cache.OutgoingChangesetCache;
import com.vectrace.MercurialEclipse.wizards.ConfigurationWizardMainPage;
import com.vectrace.MercurialEclipse.wizards.HgWizard;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.OutgoingPage;
import com.vectrace.MercurialEclipse.wizards.PushPullPage;
import com.vectrace.MercurialEclipse.wizards.PushRepoPage;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PushRepoWizard
extends HgWizard {
    private IProject project;
    private String projectName;
    private OutgoingPage outgoingPage;

    private PushRepoWizard() {
        super(Messages.getString("PushRepoWizard.title"));
        this.setNeedsProgressMonitor(true);
    }

    public PushRepoWizard(IResource resource) {
        this();
        this.project = resource.getProject();
    }

    public void addPages() {
        super.addPages();
        PushRepoPage myPage = new PushRepoPage(Messages.getString("PushRepoWizard.pushRepoPage.name"), Messages.getString("PushRepoWizard.pushRepoPage.title"), null, (IResource)this.project);
        this.initPage(Messages.getString("PushRepoWizard.pushRepoPage.description"), myPage);
        myPage.setShowCredentials(true);
        this.page = myPage;
        this.addPage((IWizardPage)this.page);
        this.outgoingPage = new OutgoingPage("OutgoingPage");
        this.initPage(this.outgoingPage.getDescription(), this.outgoingPage);
        this.outgoingPage.setProject(this.project);
        this.addPage((IWizardPage)this.outgoingPage);
    }

    public boolean performFinish() {
        HgRepositoryLocation repo;
        block12: {
            super.performFinish();
            Properties props = this.page.getProperties();
            repo = MercurialEclipsePlugin.getRepoManager().fromProperties(props);
            if (this.project.getLocation() != null) break block12;
            String msg = String.valueOf(Messages.getString("PushRepoWizard.project")) + this.projectName + Messages.getString("PushRepoWizard.notExists");
            MercurialEclipsePlugin.logError(msg, null);
            return false;
        }
        try {
            ChangeSet cs;
            PushPullPage pushRepoPage = (PushPullPage)this.page;
            int timeout = 300000;
            if (!pushRepoPage.isTimeout()) {
                timeout = Integer.MAX_VALUE;
            }
            String changeset = null;
            if (this.outgoingPage.getRevisionCheckBox().getSelection() && (cs = this.outgoingPage.getRevision()) != null) {
                changeset = cs.getChangeset();
            }
            String result = Messages.getString("PushRepoWizard.pushOutput.header");
            if (pushRepoPage.isShowSvn() && pushRepoPage.getSvnCheckBox().getSelection()) {
                result = String.valueOf(result) + HgSvnClient.push(this.project.getLocation().toFile());
            } else if (pushRepoPage.isShowForest() && pushRepoPage.getForestCheckBox().getSelection()) {
                File forestRoot = MercurialTeamProvider.getHgRoot(this.project.getLocation().toFile()).getParentFile();
                File snapFile = null;
                String snapFileText = pushRepoPage.getSnapFileCombo().getText();
                if (snapFileText.length() > 0) {
                    snapFile = new File(snapFileText);
                }
                result = String.valueOf(result) + HgFpushPullClient.fpush(forestRoot, repo, changeset, timeout, snapFile);
            } else {
                result = String.valueOf(result) + HgPushPullClient.push(this.project, repo, pushRepoPage.isForce(), changeset, timeout);
            }
            if (result.length() != 0) {
                HgClients.getConsole().printMessage(result, null);
            }
            MercurialEclipsePlugin.getRepoManager().addRepoLocation(this.project, repo);
            OutgoingChangesetCache.getInstance().clear(repo);
        }
        catch (URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("PushRepoWizard.malformedUrl"), (String)e.getMessage());
            return false;
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)e.getMessage(), (String)e.getMessage());
            return false;
        }
        return true;
    }

    protected HgWizardPage createPage(String pageName, String pageTitle, String iconPath, String description) {
        this.page = new ConfigurationWizardMainPage(pageName, pageTitle, MercurialEclipsePlugin.getImageDescriptor(iconPath));
        this.initPage(description, this.page);
        return this.page;
    }
}

