/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.synchronize.HgSubscriberMergeContext;
import com.vectrace.MercurialEclipse.synchronize.MercurialSynchronizeParticipant;
import com.vectrace.MercurialEclipse.synchronize.MercurialSynchronizeSubscriber;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.wizards.CloneRepoWizard;
import com.vectrace.MercurialEclipse.wizards.ConfigurationWizardMainPage;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.net.URISyntaxException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelParticipantWizard;

public class MercurialParticipantSynchronizeWizard
extends ModelParticipantWizard
implements IWizard {
    private final IWizard importWizard = new CloneRepoWizard();
    private HgWizardPage page;
    private Properties pageProperties = null;

    public MercurialParticipantSynchronizeWizard() {
        IDialogSettings workbenchSettings = MercurialEclipsePlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("MercurialParticipantSynchronizeWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("MercurialParticipantSynchronizeWizard");
        }
        this.setDialogSettings(section);
    }

    protected IWizard getImportWizard() {
        return this.importWizard;
    }

    protected String getPageTitle() {
        return Messages.getString("MercurialParticipantSynchronizeWizard.pageTitle");
    }

    protected IResource[] getRootResources() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public void addPages() {
        super.addPages();
        IProject[] projects = MercurialStatusCache.getInstance().getAllManagedProjects();
        if (projects != null) {
            ConfigurationWizardMainPage mainPage = new ConfigurationWizardMainPage(Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.name"), Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.title"), MercurialEclipsePlugin.getImageDescriptor(Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.image")));
            mainPage.setShowBundleButton(false);
            mainPage.setShowCredentials(true);
            this.page = mainPage;
            this.page.setDescription(Messages.getString("MercurialParticipantSynchronizeWizard.repositoryPage.description"));
            this.page.setDialogSettings(this.getDialogSettings());
            this.addPage((IWizardPage)this.page);
        }
    }

    public boolean performFinish() {
        this.page.finish((IProgressMonitor)new NullProgressMonitor());
        this.pageProperties = this.page.getProperties();
        return super.performFinish();
    }

    protected ISynchronizeParticipant createParticipant(ResourceMapping[] selectedMappings) {
        String url = this.pageProperties.getProperty("url");
        String user = this.pageProperties.getProperty("user");
        String pass = this.pageProperties.getProperty("password");
        try {
            HgRepositoryLocation repo = MercurialEclipsePlugin.getRepoManager().getRepoLocation(url, user, pass);
            ISynchronizationScope scope = null;
            MercurialSynchronizeSubscriber subscriber = new MercurialSynchronizeSubscriber(scope, repo);
            SubscriberScopeManager manager = new SubscriberScopeManager("HgSubscriberScopeManager", selectedMappings, (Subscriber)subscriber, false);
            HgSubscriberMergeContext ctx = new HgSubscriberMergeContext(subscriber, (ISynchronizationScopeManager)manager);
            return new MercurialSynchronizeParticipant((MergeContext)ctx, repo);
        }
        catch (URISyntaxException e) {
            MercurialEclipsePlugin.logError(e);
            this.page.setErrorMessage(e.getLocalizedMessage());
            return null;
        }
    }
}

