/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.FileStatus;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.ui.ChangeSetLabelProvider;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.utils.CompareUtils;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingPage
extends HgWizardPage {
    TableViewer changeSetViewer;
    private TableViewer fileStatusViewer;
    private IProject project;
    private HgRepositoryLocation location;
    private Button revisionCheckBox;
    private ChangeSet revision;
    private SortedSet<ChangeSet> changesets;
    private boolean svn;

    public IProject getProject() {
        return this.project;
    }

    public HgRepositoryLocation getLocation() {
        return this.location;
    }

    public void setRevision(ChangeSet revision) {
        this.revision = revision;
    }

    public void setChangesets(SortedSet<ChangeSet> changesets) {
        this.changesets = changesets;
    }

    protected IncomingPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("IncomingPage.title"));
        this.setDescription(Messages.getString("IncomingPage.description"));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.getInputForPage();
                this.changeSetViewer.setInput(this.changesets);
            }
            catch (InvocationTargetException e) {
                MercurialEclipsePlugin.logError(e);
                this.setErrorMessage(e.getLocalizedMessage());
            }
            catch (InterruptedException e) {
                MercurialEclipsePlugin.logError(e);
                this.setErrorMessage(e.getLocalizedMessage());
            }
        }
    }

    protected void getInputForPage() throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, false, (IRunnableWithProgress)new GetIncomingOperation((IRunnableContext)this.getContainer()));
    }

    public void createControl(Composite parent) {
        TableColumn column;
        Composite container = SWTWidgetHelper.createComposite(parent, 1);
        this.setControl((Control)container);
        this.changeSetViewer = new TableViewer(container, 68356);
        this.changeSetViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.changeSetViewer.setLabelProvider((IBaseLabelProvider)new ChangeSetLabelProvider());
        Table table = this.changeSetViewer.getTable();
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.minimumHeight = 50;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] titles = new String[]{Messages.getString("IncomingPage.columnHeader.revision"), Messages.getString("IncomingPage.columnHeader.global"), Messages.getString("IncomingPage.columnHeader.date"), Messages.getString("IncomingPage.columnHeader.author"), Messages.getString("IncomingPage.columnHeader.branch"), Messages.getString("IncomingPage.columnHeader.summary")};
        int[] widths = new int[]{42, 100, 122, 80, 80, 150};
        int i = 0;
        while (i < titles.length) {
            column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
        this.fileStatusViewer = new TableViewer(container, 68356);
        this.fileStatusViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fileStatusViewer.setLabelProvider((IBaseLabelProvider)new FileStatusLabelProvider());
        table = this.fileStatusViewer.getTable();
        gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.minimumHeight = 50;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        titles = new String[]{Messages.getString("IncomingPage.fileStatusTable.columnTitle.status"), Messages.getString("IncomingPage.fileStatusTable.columnTitle.path")};
        widths = new int[]{80, 400};
        i = 0;
        while (i < titles.length) {
            column = new TableColumn(table, 0);
            column.setText(titles[i]);
            column.setWidth(widths[i]);
            ++i;
        }
        Group group = SWTWidgetHelper.createGroup(container, Messages.getString("IncomingPage.group.title"));
        this.revisionCheckBox = SWTWidgetHelper.createCheckBox((Composite)group, Messages.getString("IncomingPage.revisionCheckBox.title"));
        this.makeActions();
    }

    ChangeSet getSelectedChangeSet() {
        IStructuredSelection sel = (IStructuredSelection)this.changeSetViewer.getSelection();
        Object firstElement = sel.getFirstElement();
        if (firstElement instanceof ChangeSet) {
            return (ChangeSet)firstElement;
        }
        return null;
    }

    private void makeActions() {
        this.changeSetViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChangeSet change = IncomingPage.this.getSelectedChangeSet();
                IncomingPage.this.revision = change;
                if (change != null) {
                    IncomingPage.this.fileStatusViewer.setInput((Object)change.getChangedFiles());
                } else {
                    IncomingPage.this.fileStatusViewer.setInput((Object)new Object[0]);
                }
            }
        });
        this.fileStatusViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ChangeSet cs = IncomingPage.this.getSelectedChangeSet();
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                FileStatus clickedFileStatus = (FileStatus)sel.getFirstElement();
                if (cs != null && clickedFileStatus != null) {
                    try {
                        Path hgRoot = new Path(cs.getHgRoot().getCanonicalPath());
                        Path fileRelPath = new Path(clickedFileStatus.getPath());
                        IPath fileAbsPath = hgRoot.append((IPath)fileRelPath);
                        IFile file = IncomingPage.this.project.getWorkspace().getRoot().getFileForLocation(fileAbsPath);
                        CompareUtils.openEditor((IResource)file, cs, true, true);
                    }
                    catch (IOException e) {
                        IncomingPage.this.setErrorMessage(e.getLocalizedMessage());
                        MercurialEclipsePlugin.logError(e);
                    }
                }
            }
        });
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setLocation(HgRepositoryLocation repo) {
        this.location = repo;
    }

    public Button getRevisionCheckBox() {
        return this.revisionCheckBox;
    }

    public ChangeSet getRevision() {
        return this.revision;
    }

    public SortedSet<ChangeSet> getChangesets() {
        return this.changesets;
    }

    public void setSvn(boolean svn) {
        this.svn = svn;
    }

    public boolean isSvn() {
        return this.svn;
    }

    static class FileStatusLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        FileStatusLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof FileStatus)) {
                return String.valueOf(Messages.getString("IncomingPage.unknownElement")) + element;
            }
            FileStatus status = (FileStatus)element;
            switch (columnIndex) {
                case 0: {
                    return status.getAction().name();
                }
                case 1: {
                    return status.getPath();
                }
            }
            return Messages.getString("IncomingPage.notApplicable");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetIncomingOperation
    extends HgOperation {
        public GetIncomingOperation(IRunnableContext context) {
            super(context);
        }

        @Override
        protected String getActionDescription() {
            return Messages.getString("IncomingPage.getIncomingOperation.description");
        }

        @Override
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.getString("IncomingPage.getIncomingOperation.beginTask"), 1);
            monitor.subTask(Messages.getString("IncomingPage.getIncomingOperation.call"));
            IncomingPage.this.changesets = this.getIncomingInternal();
            monitor.worked(1);
            monitor.done();
        }

        private SortedSet<ChangeSet> getIncomingInternal() {
            try {
                if (!IncomingPage.this.isSvn()) {
                    HgRepositoryLocation remote = IncomingPage.this.location;
                    SortedSet<ChangeSet> set = IncomingChangesetCache.getInstance().getIncomingChangeSets((IResource)IncomingPage.this.project, remote);
                    if (set != null) {
                        TreeSet<ChangeSet> revertedSet = new TreeSet<ChangeSet>(Collections.reverseOrder());
                        revertedSet.addAll(set);
                        return revertedSet;
                    }
                }
            }
            catch (HgException e) {
                MercurialEclipsePlugin.showError((Throwable)((Object)e));
            }
            return new TreeSet<ChangeSet>();
        }
    }
}

