/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportOptionsPage
extends HgWizardPage
implements Listener {
    private Button chkGit;
    private Button chkBase;
    private Button chkText;
    private Button chkFunction;
    private Text txtUnified;
    private Button chkUnified;
    private Text txtBase;
    private Button chkNoDate;
    private Button chkIgnoreAllSpace;
    private Button chkIgnoreSpaceChange;
    private Button chkIgnoreBlankLines;

    public ExportOptionsPage() {
        super(Messages.getString("ImportWizard.optionsPageName"), Messages.getString("ImportWizard.optionsPageTitle"), null);
    }

    protected boolean validatePage() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 2);
        this.chkGit = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ExportOptionsPage.git"));
        this.chkText = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ExportOptionsPage.text"));
        this.chkBase = ExportOptionsPage.createLabelCheckBox(composite, Messages.getString("ExportOptionsPage.rev"));
        this.chkBase.addListener(13, (Listener)this);
        this.txtBase = SWTWidgetHelper.createTextField(composite);
        this.chkFunction = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ExportOptionsPage.function"));
        this.chkNoDate = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ExportOptionsPage.noDate"));
        this.chkIgnoreAllSpace = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ExportOptionsPage.ignoreAllSpace"));
        this.chkIgnoreSpaceChange = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ExportOptionsPage.ignoreSpaceChange"));
        this.chkIgnoreBlankLines = SWTWidgetHelper.createCheckBox(composite, Messages.getString("ExportOptionsPage.ignoreBlankLines"));
        this.chkUnified = ExportOptionsPage.createLabelCheckBox(composite, Messages.getString("ExportOptionsPage.context"));
        this.chkUnified.addListener(13, (Listener)this);
        this.txtUnified = SWTWidgetHelper.createTextField(composite);
        this.setControl((Control)composite);
        this.validate();
    }

    public void handleEvent(Event event) {
        this.validate();
    }

    private void validate() {
        this.txtUnified.setEnabled(this.chkUnified.getSelection());
        this.txtBase.setEnabled(this.chkBase.getSelection());
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    @Override
    public boolean finish(IProgressMonitor monitor) {
        return super.finish(monitor);
    }

    ArrayList<String> getOptions() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.chkBase.getSelection()) {
            list.add("-r " + this.txtBase.getText());
        }
        if (this.chkText.getSelection()) {
            list.add("-a");
        }
        if (this.chkGit.getSelection()) {
            list.add("-g");
        }
        if (this.chkFunction.getSelection()) {
            list.add("-p");
        }
        if (this.chkNoDate.getSelection()) {
            list.add("--nodates");
        }
        if (this.chkIgnoreAllSpace.getSelection()) {
            list.add("-w");
        }
        if (this.chkIgnoreSpaceChange.getSelection()) {
            list.add("-b");
        }
        if (this.chkIgnoreBlankLines.getSelection()) {
            list.add("-B");
        }
        if (this.chkUnified.getSelection()) {
            list.add("-U " + this.txtUnified.getText());
        }
        return list;
    }

    public static Button createLabelCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        return button;
    }
}

