/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.RepositoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingChangesetCache
extends AbstractCache {
    private static IncomingChangesetCache instance = null;
    private static Map<IResource, ReentrantLock> locks = new HashMap<IResource, ReentrantLock>();
    private static Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> incomingChangeSets;

    private IncomingChangesetCache() {
        incomingChangeSets = new HashMap<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>>();
    }

    public static IncomingChangesetCache getInstance() {
        if (instance == null) {
            instance = new IncomingChangesetCache();
        }
        return instance;
    }

    public synchronized void clear(HgRepositoryLocation repo) {
        incomingChangeSets.remove(repo);
    }

    public synchronized void clear() {
        incomingChangeSets.clear();
        locks.clear();
    }

    private ReentrantLock getLock(IResource objectResource) {
        ReentrantLock lock = locks.get(objectResource.getProject());
        if (lock == null) {
            lock = new ReentrantLock();
            locks.put((IResource)objectResource.getProject(), lock);
        }
        return lock;
    }

    public SortedSet<ChangeSet> getIncomingChangeSets(IResource objectResource) throws HgException {
        ReentrantLock lock = this.getLock(objectResource);
        if (lock.isLocked()) {
            lock.lock();
            lock.unlock();
        }
        Set<HgRepositoryLocation> repos = MercurialEclipsePlugin.getRepoManager().getAllProjectRepoLocations(objectResource.getProject());
        TreeSet<ChangeSet> allChanges = new TreeSet<ChangeSet>();
        for (HgRepositoryLocation hgRepositoryLocation : repos) {
            SortedSet<ChangeSet> repoChanges = this.getIncomingChangeSets(objectResource, hgRepositoryLocation);
            if (repoChanges == null) continue;
            allChanges.addAll(repoChanges);
        }
        return Collections.unmodifiableSortedSet(allChanges);
    }

    public SortedSet<ChangeSet> getIncomingChangeSets(IResource objectResource, HgRepositoryLocation repositoryLocation) throws HgException {
        ReentrantLock lock = this.getLock(objectResource);
        if (lock.isLocked()) {
            lock.lock();
            lock.unlock();
        }
        Map<IPath, SortedSet<ChangeSet>> repoIncoming = incomingChangeSets.get(repositoryLocation);
        SortedSet<ChangeSet> revisions = null;
        if (repoIncoming != null) {
            revisions = repoIncoming.get(objectResource.getLocation());
        }
        if (revisions == null) {
            this.refreshIncomingChangeSets(objectResource.getProject(), repositoryLocation);
            repoIncoming = incomingChangeSets.get(repositoryLocation);
            if (repoIncoming != null) {
                revisions = repoIncoming.get(objectResource.getLocation());
            }
        }
        if (revisions != null) {
            return Collections.unmodifiableSortedSet(incomingChangeSets.get(repositoryLocation).get(objectResource.getLocation()));
        }
        return null;
    }

    public IResource[] getIncomingMembers(IResource resource, HgRepositoryLocation repositoryLocation) {
        ReentrantLock lock = this.getLock(resource);
        try {
            lock.lock();
            ArrayList<IResource> members = new ArrayList<IResource>();
            Map<IPath, SortedSet<ChangeSet>> changeSets = incomingChangeSets.get(repositoryLocation);
            members.addAll(this.getMembers(resource, changeSets));
            IResource[] iResourceArray = members.toArray(new IResource[members.size()]);
            return iResourceArray;
        }
        finally {
            lock.unlock();
        }
    }

    public ChangeSet getNewestIncomingChangeSet(IResource objectResource) throws HgException {
        Set<HgRepositoryLocation> locs = MercurialEclipsePlugin.getRepoManager().getAllProjectRepoLocations(objectResource.getProject());
        TreeSet<ChangeSet> changeSets = new TreeSet<ChangeSet>();
        for (HgRepositoryLocation hgRepositoryLocation : locs) {
            ChangeSet candidate = this.getNewestIncomingChangeSet(objectResource, hgRepositoryLocation);
            if (candidate == null) continue;
            changeSets.add(candidate);
        }
        if (changeSets.size() > 0) {
            return (ChangeSet)changeSets.last();
        }
        return null;
    }

    public ChangeSet getNewestIncomingChangeSet(IResource resource, HgRepositoryLocation repositoryLocation) throws HgException {
        ReentrantLock lock = this.getLock(resource);
        if (lock.isLocked()) {
            lock.lock();
            lock.unlock();
        }
        if (MercurialStatusCache.getInstance().isSupervised(resource) || !resource.exists()) {
            Map<IPath, SortedSet<ChangeSet>> repoMap = incomingChangeSets.get(repositoryLocation);
            SortedSet<ChangeSet> revisions = null;
            if (repoMap != null) {
                revisions = repoMap.get(resource.getLocation());
            }
            if (revisions != null && revisions.size() > 0) {
                return revisions.last();
            }
        }
        return null;
    }

    public boolean isIncomingStatusKnown(IProject project) {
        ReentrantLock lock = this.getLock((IResource)project);
        if (lock.isLocked()) {
            lock.lock();
            lock.unlock();
        }
        if (incomingChangeSets != null && incomingChangeSets.size() > 0) {
            Iterator<HgRepositoryLocation> iterator = incomingChangeSets.keySet().iterator();
            while (iterator.hasNext()) {
                Map<IPath, SortedSet<ChangeSet>> currLocMap = incomingChangeSets.get(iterator.next());
                if (currLocMap == null || currLocMap.get(project.getLocation()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void refreshIncomingChangeSets(IProject project, HgRepositoryLocation repositoryLocation) throws HgException {
        Assert.isNotNull((Object)project);
        if (RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") != null && project.isOpen()) {
            ReentrantLock lock = this.getLock((IResource)project);
            try {
                lock.lock();
                this.addResourcesToCache(project, repositoryLocation, incomingChangeSets, ChangeSet.Direction.INCOMING);
            }
            finally {
                lock.unlock();
                this.notifyChanged((IResource)project);
            }
        }
    }
}

