/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgBranchClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.DecoratorImages;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import com.vectrace.MercurialEclipse.team.cache.RefreshStatusJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
Observer {
    private static final MercurialStatusCache STATUS_CACHE = MercurialStatusCache.getInstance();
    private static final IncomingChangesetCache INCOMING_CACHE = IncomingChangesetCache.getInstance();
    private static final LocalChangesetCache LOCAL_CACHE = LocalChangesetCache.getInstance();
    private static String[] fonts = new String[]{"com.vectrace.mercurialeclipse.ui.colorsandfonts.addedFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredFont", "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedFont"};
    private static String[] colors = new String[]{"com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor", "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor"};
    private static boolean folder_logic_2MM;
    private ITheme theme;

    public ResourceDecorator() {
        ResourceDecorator.configureFromPreferences();
        STATUS_CACHE.addObserver(this);
        LOCAL_CACHE.addObserver(this);
        INCOMING_CACHE.addObserver(this);
        this.theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        this.ensureFontAndColorsCreated(fonts, colors);
    }

    private void ensureFontAndColorsCreated(final String[] f, final String[] c) {
        MercurialEclipsePlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                int i = 0;
                while (i < c.length) {
                    ResourceDecorator.this.theme.getColorRegistry().get(c[i]);
                    ++i;
                }
                i = 0;
                while (i < f.length) {
                    ResourceDecorator.this.theme.getFontRegistry().get(f[i]);
                    ++i;
                }
            }
        });
    }

    public void dispose() {
        STATUS_CACHE.deleteObserver(this);
        STATUS_CACHE.clear();
        INCOMING_CACHE.deleteObserver(this);
        INCOMING_CACHE.clear();
        LOCAL_CACHE.deleteObserver(this);
        LOCAL_CACHE.clear();
        AbstractCache.clearNodeMap();
        super.dispose();
    }

    private static void configureFromPreferences() {
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        folder_logic_2MM = "2-means-modified".equals(store.getString("hg.labeldecorator.logic"));
    }

    public void decorate(Object element, IDecoration d) {
        try {
            IResource resource = (IResource)element;
            IProject project = resource.getProject();
            if (project == null || RepositoryProvider.getProvider((IProject)project, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") == null || !project.isAccessible()) {
                return;
            }
            if (!MercurialUtilities.hgIsTeamProviderFor(resource, false)) {
                return;
            }
            boolean coloriseLabels = this.isColorise();
            boolean showChangeset = this.isShowChangeset();
            if (showChangeset) {
                if (!(STATUS_CACHE.getLock((IResource)project).isLocked() || STATUS_CACHE.getLock(resource).isLocked() || STATUS_CACHE.isStatusKnown(project) || LOCAL_CACHE.isLocalUpdateInProgress((IResource)project) || LOCAL_CACHE.isLocalUpdateInProgress(resource) || LOCAL_CACHE.isLocallyKnown((IResource)resource.getProject()))) {
                    RefreshJob job = new RefreshJob(Messages.getString("ResourceDecorator.refreshingChangesetDeco"), null, resource.getProject(), showChangeset);
                    job.schedule();
                    job.join();
                    return;
                }
            } else if (!(STATUS_CACHE.getLock((IResource)project).isLocked() || STATUS_CACHE.getLock(resource).isLocked() || STATUS_CACHE.isStatusKnown(project))) {
                RefreshStatusJob job = new RefreshStatusJob(String.valueOf(Messages.getString("ResourceDecorator.updatingStatusForProject.1")) + project.getName() + Messages.getString("ResourceDecorator.updatingStatusForProject.2") + resource.getName(), project);
                job.schedule();
                job.join();
                return;
            }
            ImageDescriptor overlay = null;
            String prefix = null;
            BitSet output = STATUS_CACHE.getStatus(resource);
            if (output != null) {
                if (folder_logic_2MM && (output.cardinality() > 2 || output.cardinality() == 2 && !output.get(0))) {
                    overlay = DecoratorImages.modifiedDescriptor;
                    prefix = ">";
                    if (coloriseLabels) {
                        this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor");
                        this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor");
                        this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedFont");
                    }
                } else {
                    switch (output.length() - 1) {
                        case 0: {
                            if (!coloriseLabels) break;
                            this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredBackgroundColor");
                            this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredForegroundColor");
                            this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.ignoredFont");
                            break;
                        }
                        case 6: {
                            overlay = DecoratorImages.modifiedDescriptor;
                            prefix = ">";
                            if (!coloriseLabels) break;
                            this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor");
                            this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor");
                            this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.changedFont");
                            break;
                        }
                        case 5: {
                            overlay = DecoratorImages.addedDescriptor;
                            prefix = ">";
                            if (!coloriseLabels) break;
                            this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor");
                            this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor");
                            this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.addedFont");
                            break;
                        }
                        case 4: {
                            overlay = DecoratorImages.notTrackedDescriptor;
                            prefix = ">";
                            if (!coloriseLabels) break;
                            this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor");
                            this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor");
                            this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownFont");
                            break;
                        }
                        case 1: {
                            overlay = DecoratorImages.managedDescriptor;
                            break;
                        }
                        case 3: {
                            overlay = DecoratorImages.removedDescriptor;
                            prefix = ">";
                            if (!coloriseLabels) break;
                            this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor");
                            this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor");
                            this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.removedFont");
                            break;
                        }
                        case 2: {
                            overlay = DecoratorImages.deletedStillTrackedDescriptor;
                            prefix = ">";
                            if (!coloriseLabels) break;
                            this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor");
                            this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor");
                            this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedFont");
                            break;
                        }
                        case 8: {
                            overlay = DecoratorImages.conflictDescriptor;
                            prefix = ">";
                            if (!coloriseLabels) break;
                            this.setBackground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor");
                            this.setForeground(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor");
                            this.setFont(d, "com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictFont");
                        }
                    }
                }
            }
            if (overlay != null) {
                d.addOverlay(overlay);
            }
            if (showChangeset) {
                ChangeSet newestIncomingChangeSet = null;
                try {
                    newestIncomingChangeSet = INCOMING_CACHE.getNewestIncomingChangeSet(resource);
                }
                catch (HgException e1) {
                    MercurialEclipsePlugin.logError((Throwable)((Object)e1));
                }
                if (newestIncomingChangeSet != null) {
                    prefix = prefix == null ? "<" : "<" + prefix;
                }
                try {
                    String suffix = "";
                    if (resource.getType() == 4) {
                        suffix = this.getSuffixForProject(project);
                    }
                    if (resource.getType() == 1) {
                        suffix = this.getSuffixForFiles(resource, newestIncomingChangeSet);
                    }
                    if (resource.getType() != 2) {
                        d.addSuffix(suffix);
                    }
                }
                catch (HgException e) {
                    MercurialEclipsePlugin.logWarning(String.valueOf(Messages.getString("ResourceDecorator.couldntGetVersionOfResource")) + resource, (Throwable)((Object)e));
                }
            } else if (resource.getType() == 4) {
                String suffix = this.getSuffixForProject(project);
                d.addSuffix(suffix);
            }
            if (prefix != null) {
                d.addPrefix(prefix);
            }
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
        }
    }

    private void setBackground(IDecoration d, String id) {
        d.setBackgroundColor(this.theme.getColorRegistry().get(id));
    }

    private void setForeground(IDecoration d, String id) {
        d.setForegroundColor(this.theme.getColorRegistry().get(id));
    }

    private void setFont(IDecoration d, String id) {
        d.setFont(this.theme.getFontRegistry().get(id));
    }

    private boolean isShowChangeset() {
        boolean showChangeset = Boolean.valueOf(HgClients.getPreference("hg.performance.fileShowsChangeset", "false"));
        return showChangeset;
    }

    private boolean isColorise() {
        boolean colorise = Boolean.valueOf(HgClients.getPreference("hg.labeldecorator.colors", "false"));
        return colorise;
    }

    private String getSuffixForFiles(IResource resource, ChangeSet cs) throws HgException {
        ChangeSet fileCs;
        String suffix = "";
        if (!(LOCAL_CACHE.isLocalUpdateInProgress((IResource)resource.getProject()) || STATUS_CACHE.isAdded((IResource)resource.getProject(), resource.getLocation()) || LOCAL_CACHE.isLocalUpdateInProgress(resource) || (fileCs = LOCAL_CACHE.getNewestLocalChangeSet(resource)) == null)) {
            suffix = " [" + fileCs.getChangesetIndex() + " - " + fileCs.getAgeDate() + " - " + fileCs.getUser() + "]";
            if (cs != null) {
                suffix = String.valueOf(suffix) + "< [" + cs.getChangesetIndex() + ":" + cs.getNodeShort() + " - " + cs.getAgeDate() + " - " + cs.getUser() + "]";
            }
        }
        return suffix;
    }

    private String getSuffixForProject(IProject project) throws CoreException, IOException {
        ChangeSet changeSet = null;
        String suffix = "";
        if (!LOCAL_CACHE.isLocalUpdateInProgress((IResource)project)) {
            if (this.isShowChangeset()) {
                LocalChangesetCache.getInstance().getLocalChangeSets((IResource)project);
            }
            changeSet = LocalChangesetCache.getInstance().getCurrentWorkDirChangeset((IResource)project);
        } else {
            suffix = Messages.getString("ResourceDecorator.new");
        }
        if (changeSet != null) {
            suffix = " [ ";
            String hex = ":" + changeSet.getNodeShort();
            String tags = changeSet.getTag();
            String merging = project.getPersistentProperty(ResourceProperties.MERGING);
            suffix = String.valueOf(suffix) + changeSet.getChangesetIndex() + hex;
            String branch = HgBranchClient.getActiveBranch(project.getLocation().toFile());
            if (branch != null && branch.length() > 0 && !branch.equals("default")) {
                suffix = String.valueOf(suffix) + " @ " + branch;
            }
            if (tags != null && tags.length() > 0) {
                suffix = String.valueOf(suffix) + " (" + tags + ")";
            }
            if (merging != null && merging.length() > 0) {
                suffix = String.valueOf(suffix) + Messages.getString("ResourceDecorator.merging") + merging;
            }
            suffix = String.valueOf(suffix) + " ]";
        }
        return suffix;
    }

    public static void onConfigurationChanged() {
        String decoratorId = ResourceDecorator.getDecoratorId();
        ResourceDecorator.configureFromPreferences();
        PlatformUI.getWorkbench().getDecoratorManager().update(decoratorId);
    }

    public static String getDecoratorId() {
        String decoratorId = ResourceDecorator.class.getName();
        return decoratorId;
    }

    @Override
    public void update(Observable o, Object updatedObject) {
        if (updatedObject instanceof Set) {
            Set changed = (Set)updatedObject;
            ArrayList<IResource> notification = new ArrayList<IResource>(1000);
            int i = 0;
            for (IResource resource : changed) {
                if (i % 1000 == 0 && notification.size() > 0) {
                    this.fireNotification(notification);
                }
                notification.add(resource);
                ++i;
            }
            if (notification.size() > 0) {
                this.fireNotification(notification);
            }
        }
    }

    private void fireNotification(List<IResource> notification) {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, notification.toArray());
        this.fireLabelProviderChanged(event);
        notification.clear();
    }
}

