/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.synchronize.Messages;
import java.net.URISyntaxException;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.mapping.provider.MergeContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public class MercurialSynchronizeParticipant
extends ModelSynchronizeParticipant {
    private static final String REPOSITORY_LOCATION = "REPOSITORY_LOCATION";
    private String secondaryId;
    private HgRepositoryLocation repositoryLocation;

    public MercurialSynchronizeParticipant(MergeContext ctx, HgRepositoryLocation repositoryLocation) {
        super((SynchronizationContext)ctx);
        this.repositoryLocation = repositoryLocation;
        this.secondaryId = new Date().toString();
    }

    public void init(String secId, IMemento memento) throws PartInitException {
        super.init(this.secondaryId, memento);
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor(this.getId());
            this.setInitializationData(descriptor);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
        }
        IMemento myMemento = memento.getChild(MercurialSynchronizeParticipant.class.getName());
        this.secondaryId = secId;
        String uri = myMemento.getString(REPOSITORY_LOCATION);
        try {
            this.repositoryLocation = MercurialEclipsePlugin.getRepoManager().getRepoLocation(uri);
        }
        catch (URISyntaxException e) {
            throw new PartInitException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public MercurialSynchronizeParticipant() {
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento myMemento = memento.createChild(MercurialSynchronizeParticipant.class.getName());
        myMemento.putString(REPOSITORY_LOCATION, this.repositoryLocation.getSaveString());
    }

    protected void initializeContext(SynchronizationContext context) {
        super.initializeContext(context);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getSecondaryId() {
        return this.secondaryId;
    }

    public String getName() {
        return Messages.getString("MercurialSynchronizeParticipant.syncOnRepo").concat("" + this.repositoryLocation);
    }

    public HgRepositoryLocation getRepositoryLocation() {
        return this.repositoryLocation;
    }
}

