/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.model;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.extensions.HgSigsClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import java.io.IOException;

public class Signature {
    private HgRoot root;
    private String key;
    private String nodeId;
    private boolean valid;
    private boolean checked;

    public Signature(String key, String nodeId, HgRoot root) {
        this.key = key;
        this.nodeId = nodeId;
        this.root = root;
    }

    public boolean validate() throws HgException {
        if (this.checked) {
            return this.isValid();
        }
        try {
            String result = HgSigsClient.checkSig(this.root.getCanonicalFile(), this.nodeId);
            if (!result.contains("No valid signature for")) {
                this.valid = true;
                this.key = result.split("\n")[1].trim();
            }
            this.checked = true;
            return this.valid;
        }
        catch (IOException e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public String toString() {
        return String.valueOf(this.valid) + ":" + this.key + ", " + this.nodeId;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setNodeId(String changeSetId) {
        this.nodeId = changeSetId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        result = 31 * result + (this.valid ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        if (this.root == null ? other.root != null : !this.root.equals(other.root)) {
            return false;
        }
        return this.valid == other.valid;
    }
}

