/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.HgUpdateClient;
import com.vectrace.MercurialEclipse.menu.SingleResourceHandler;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UpdateHandler
extends SingleResourceHandler {
    protected void run(IResource resource) throws Exception {
        final IProject project = resource.getProject();
        HgUpdateClient.update(project, null, false);
        project.setPersistentProperty(ResourceProperties.MERGING, null);
        project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
        new SafeWorkspaceJob("Refreshing project files..."){

            protected IStatus runSafe(IProgressMonitor monitor) {
                try {
                    project.refreshLocal(2, null);
                    MercurialStatusCache.getInstance().notifyChanged((IResource)project);
                    return super.runSafe(monitor);
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                    return new Status(4, "com.vectrace.MercurialEclipse", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }.schedule();
    }
}

