/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.commands.HgStatusClient;
import com.vectrace.MercurialEclipse.commands.HgUpdateClient;
import com.vectrace.MercurialEclipse.dialogs.RevisionChooserDialog;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.menu.SingleResourceHandler;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.views.MergeView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SwitchHandler
extends SingleResourceHandler {
    protected void run(IResource resource) throws Exception {
        IProject project = resource.getProject();
        if (HgStatusClient.isDirty(project) && !MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("SwitchHandler.pendingChangesConfirmation.1"), (String)Messages.getString("SwitchHandler.pendingChangesConfirmation.2"))) {
            return;
        }
        RevisionChooserDialog dialog = new RevisionChooserDialog(this.getShell(), Messages.getString("SwitchHandler.switchTo"), project);
        int result = dialog.open();
        if (result == 0) {
            HgUpdateClient.update(project, dialog.getRevision(), true);
            project.setPersistentProperty(ResourceProperties.MERGING, null);
            project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
            project.refreshLocal(2, null);
            MergeView view = MergeView.getView();
            if (view != null) {
                view.clearView();
            }
        }
    }
}

