/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.FlaggedAdaptable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgIMergeClient
extends AbstractClient {
    public static String merge(IProject project, String revision) throws HgException {
        HgCommand command = new HgCommand("imerge", (IContainer)project, false);
        command.setUsePreferenceTimeout("hg.timeout.imerge");
        boolean useExternalMergeTool = Boolean.valueOf(HgClients.getPreference("hg.merge.useExternal", "false"));
        command.addOptions("--config", "extensions.imerge=");
        if (!useExternalMergeTool) {
            command.addOptions("--config", "ui.merge=simplemerge");
        }
        if (revision != null) {
            command.addOptions("-r", revision);
        }
        return new String(command.executeToBytes());
    }

    public static List<FlaggedAdaptable> getMergeStatus(IResource res) throws HgException {
        HgCommand command = new HgCommand("imerge", HgIMergeClient.getWorkingDirectory(res), false);
        command.addOptions("--config", "extensions.imerge=");
        command.addOptions("status");
        command.setUsePreferenceTimeout("hg.timeout.imerge");
        String[] lines = command.executeToString().split("\n");
        ArrayList<FlaggedAdaptable> result = new ArrayList<FlaggedAdaptable>();
        if (lines.length != 1 || !"all conflicts resolved".equals(lines[0])) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                FlaggedAdaptable flagged = new FlaggedAdaptable((IAdaptable)res.getProject().getFile(line.substring(2)), line.charAt(0));
                result.add(flagged);
                ++n2;
            }
        }
        return result;
    }

    public static String markResolved(IResource file) throws HgException {
        HgCommand command = new HgCommand("imerge", HgIMergeClient.getWorkingDirectory(file), false);
        command.addOptions("--config", "extensions.imerge=");
        command.addOptions("resolve");
        command.setUsePreferenceTimeout("hg.timeout.imerge");
        command.addFiles(file.getProjectRelativePath().toOSString());
        String result = command.executeToString();
        return result;
    }

    public static String markUnresolved(IResource file) throws HgException {
        HgCommand command = new HgCommand("imerge", HgIMergeClient.getWorkingDirectory(file), false);
        command.addOptions("--config", "extensions.imerge=");
        command.addOptions("unresolve");
        command.setUsePreferenceTimeout("hg.timeout.imerge");
        command.addFiles(file.getProjectRelativePath().toOSString());
        String result = command.executeToString();
        return result;
    }
}

