/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HgBisectClient {
    public static String markGood(File repository, ChangeSet good) throws HgException {
        HgCommand cmd = new HgCommand("bisect", repository, true);
        cmd.addOptions("-g");
        if (good != null) {
            cmd.addOptions(HgBisectClient.getRevision(good));
        }
        return cmd.executeToString();
    }

    public static String markBad(File repository, ChangeSet bad) throws HgException {
        HgCommand cmd = new HgCommand("bisect", repository, true);
        cmd.addOptions("-b");
        if (bad != null) {
            cmd.addOptions(HgBisectClient.getRevision(bad));
        }
        return cmd.executeToString();
    }

    public static String reset(File repository) throws HgException {
        HgCommand cmd = new HgCommand("bisect", repository, true);
        cmd.addOptions("-r");
        return cmd.executeToString();
    }

    public static boolean isBisecting(File repository) {
        try {
            File file = HgBisectClient.getStatusFile(repository);
            return file.exists();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static Map<String, Status> getBisectStatus(File repository) throws HgException {
        HashMap<String, Status> statusByRevision = new HashMap<String, Status>();
        if (!HgBisectClient.isBisecting(repository)) {
            return statusByRevision;
        }
        BufferedReader reader = null;
        try {
            try {
                File file = HgBisectClient.getStatusFile(repository);
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] statusChangeset = line.split("\\s");
                    if (statusChangeset[0].equalsIgnoreCase("bad")) {
                        statusByRevision.put(statusChangeset[1].trim(), Status.BAD);
                        continue;
                    }
                    statusByRevision.put(statusChangeset[1].trim(), Status.GOOD);
                }
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
                throw new HgException(e.getLocalizedMessage(), e);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        return statusByRevision;
    }

    private static File getStatusFile(File repository) throws IOException {
        String root = repository.getCanonicalPath();
        String bisectStatusFile = String.valueOf(root) + File.separator + ".hg" + File.separator + "bisect.state";
        File file = new File(bisectStatusFile);
        return file;
    }

    private static String getRevision(ChangeSet change) {
        return Integer.toString(change.getRevision().getRevision());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        GOOD,
        BAD;

    }
}

