/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel.navigator;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNavigator;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorReferenceType;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigatorHandler {
    private GenDiagram myDiagram;
    private GenNavigator myNavigator;
    private boolean myShowLinkTargets = true;
    private boolean myShowOutgoingLinks = true;
    private boolean myShowLinkSources = true;
    private boolean myShowIncomingLinks = true;

    public void initialize(GenDiagram genDiagram, GenNavigator genNavigator) {
        this.myDiagram = genDiagram;
        this.myNavigator = genNavigator;
        this.process(this.myDiagram);
    }

    public void process(GenDiagram diagram) {
        this.createChildReference((GenCommonBase)diagram, null, GenNavigatorReferenceType.CHILDREN_LITERAL);
    }

    public void process(GenTopLevelNode topLevelNode) {
        this.createChildNodeReference((GenNode)topLevelNode, (GenCommonBase)this.myDiagram);
    }

    public void process(GenChildNode childNode, GenChildContainer container) {
        GenNode parent = null;
        if (container instanceof GenCompartment) {
            parent = ((GenCompartment)container).getNode();
        } else if (container instanceof GenNode) {
            parent = (GenNode)container;
        }
        assert (parent != null);
        this.createChildNodeReference((GenNode)childNode, (GenCommonBase)parent);
    }

    public void process(GenLink link) {
        GenNavigatorChildReference childReference = this.createChildReference((GenCommonBase)link, (GenCommonBase)this.myDiagram, GenNavigatorReferenceType.CHILDREN_LITERAL);
        childReference.setGroupName("links");
        childReference.setGroupIcon("icons/linksNavigatorGroup.gif");
        Collection<GenNode> targetNodes = this.getTargetGenNodes(link);
        for (GenNode node : targetNodes) {
            GenNavigatorChildReference reference;
            if (this.myShowLinkTargets) {
                reference = this.createChildReference((GenCommonBase)node, (GenCommonBase)link, GenNavigatorReferenceType.OUT_TARGET_LITERAL);
                reference.setGroupName("target");
                reference.setGroupIcon("icons/linkTargetNavigatorGroup.gif");
            }
            if (!this.myShowIncomingLinks) continue;
            reference = this.createChildReference((GenCommonBase)link, (GenCommonBase)node, GenNavigatorReferenceType.IN_SOURCE_LITERAL);
            reference.setGroupName("incoming links");
            reference.setGroupIcon("icons/incomingLinksNavigatorGroup.gif");
        }
        Collection<GenNode> sourceNodes = this.getSourceGenNodes(link);
        for (GenNode node : sourceNodes) {
            GenNavigatorChildReference reference;
            if (this.myShowLinkSources) {
                reference = this.createChildReference((GenCommonBase)node, (GenCommonBase)link, GenNavigatorReferenceType.IN_SOURCE_LITERAL);
                reference.setGroupName("source");
                reference.setGroupIcon("icons/linkSourceNavigatorGroup.gif");
            }
            if (!this.myShowOutgoingLinks) continue;
            reference = this.createChildReference((GenCommonBase)link, (GenCommonBase)node, GenNavigatorReferenceType.OUT_TARGET_LITERAL);
            reference.setGroupName("outgoing links");
            reference.setGroupIcon("icons/outgoingLinksNavigatorGroup.gif");
        }
    }

    private Collection<GenNode> getTargetGenNodes(GenLink link) {
        if (link.getModelFacet() == null) {
            return this.myDiagram.getAllNodes();
        }
        return this.getAssignableGenNodes(link.getModelFacet().getTargetType());
    }

    private Collection<GenNode> getSourceGenNodes(GenLink link) {
        if (link.getModelFacet() == null) {
            return this.myDiagram.getAllNodes();
        }
        return this.getAssignableGenNodes(link.getModelFacet().getSourceType());
    }

    private Collection<GenNode> getAssignableGenNodes(GenClass genClass) {
        if (genClass == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<GenNode> result = new LinkedHashSet<GenNode>();
        for (GenNode nextNode : this.myDiagram.getAllNodes()) {
            if (nextNode.getModelFacet() == null || !genClass.getEcoreClass().isSuperTypeOf(nextNode.getDomainMetaClass().getEcoreClass())) continue;
            result.add(nextNode);
        }
        return result;
    }

    private void createChildNodeReference(GenNode childNode, GenCommonBase parent) {
        this.createChildReference((GenCommonBase)childNode, parent, GenNavigatorReferenceType.CHILDREN_LITERAL);
    }

    private GenNavigatorChildReference createChildReference(GenCommonBase child, GenCommonBase parent, GenNavigatorReferenceType referenceType) {
        GenNavigatorChildReference childReference = GMFGenFactory.eINSTANCE.createGenNavigatorChildReference();
        if (parent != null) {
            childReference.setParent(parent);
        }
        childReference.setChild(child);
        childReference.setReferenceType(referenceType);
        this.myNavigator.getChildReferences().add((Object)childReference);
        return childReference;
    }
}

