/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.IMergeInputProvider;
import com.collabnet.subversion.merge.MergeOperation;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizardLastPage;
import com.collabnet.subversion.merge.wizards.MergeWizardMainPage;
import com.collabnet.subversion.merge.wizards.MergeWizardStandardPage;
import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class ReintegrateMergeInputProvider
implements IMergeInputProvider {
    private String text;
    private String description;
    private int sequence;
    private Image image;
    private MergeWizardStandardPage standardPage;
    private WizardPage[] wizardPages;

    public boolean enabledForMultipleSelection() {
        return true;
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        return null;
    }

    public int getSequence() {
        return this.sequence;
    }

    public String getText() {
        return this.text;
    }

    public IWizardPage[] getWizardPages(boolean initializePages) {
        if (this.wizardPages == null || initializePages) {
            this.standardPage = new MergeWizardStandardPage("standardReintegrate", Messages.ReintegrateMergeInputProvider_selectMergeSource, Activator.getDefault().getImageDescriptor("mergestream_wizban.png"), Messages.ReintegrateMergeInputProvider_specifyLocation, false, false, true);
            WizardPage[] pages = new WizardPage[]{this.standardPage};
            this.wizardPages = pages;
        }
        return this.wizardPages;
    }

    public boolean performMerge(MergeWizardMainPage mainPage, MergeWizardLastPage optionsPage, IWorkbenchPart targetPart) {
        boolean localMods = false;
        boolean switchedChildren = false;
        boolean mixedRevisions = false;
        IResource[] resources = this.standardPage.getResources();
        int i = 0;
        block4: while (i < resources.length) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)resources[i]);
            try {
                ISVNClientAdapter svnClient = svnResource.getRepository().getSVNClient();
                File file = new File(resources[i].getLocation().toString());
                ISVNStatus[] statuses = svnClient.getStatus(file, true, true, false, true);
                SVNRevision.Number lastRevision = null;
                int j = 0;
                while (j < statuses.length) {
                    if (statuses[j].getTextStatus().equals((Object)SVNStatusKind.MODIFIED) | statuses[j].getPropStatus().equals((Object)SVNStatusKind.MODIFIED)) {
                        localMods = true;
                        break block4;
                    }
                    if (statuses[j].isSwitched()) {
                        switchedChildren = true;
                        break block4;
                    }
                    if (!statuses[j].getTextStatus().equals((Object)SVNStatusKind.EXTERNAL) && statuses[j].getRevision() != null) {
                        if (lastRevision != null && !statuses[j].getRevision().equals((Object)lastRevision)) {
                            mixedRevisions = true;
                            break block4;
                        }
                        lastRevision = statuses[j].getRevision();
                    }
                    ++j;
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (localMods) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReintegrateMergeInputProvider_merge, (String)Messages.ReintegrateMergeInputProvider_localModificationsError);
            return false;
        }
        if (switchedChildren) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReintegrateMergeInputProvider_merge, (String)Messages.ReintegrateMergeInputProvider_switchedError);
            return false;
        }
        if (mixedRevisions) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReintegrateMergeInputProvider_merge, (String)Messages.ReintegrateMergeInputProvider_mixedRevisionsError);
            return false;
        }
        MergeOperation mergeOperation = new MergeOperation(targetPart, resources, this.standardPage.getUrls(), null, this.standardPage.getUrls(), null, null, null);
        mergeOperation.setReintegrate(true);
        mergeOperation.setForce(optionsPage.isForce());
        mergeOperation.setIgnoreAncestry(optionsPage.isIgnore());
        mergeOperation.setDepth(optionsPage.getDepth());
        mergeOperation.setTextConflictHandling(optionsPage.getTextConflictHandling());
        mergeOperation.setBinaryConflictHandling(optionsPage.getBinaryConflictHandling());
        mergeOperation.setPropertyConflictHandling(optionsPage.getPropertyConflictHandling());
        try {
            mergeOperation.run();
        }
        catch (Exception e) {
            Activator.handleError(Messages.ReintegrateMergeInputProvider_error, e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ReintegrateMergeInputProvider_merge, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean showOptionsPage() {
        return true;
    }

    public int compareTo(Object compareToObject) {
        if (!(compareToObject instanceof IMergeInputProvider)) {
            return 0;
        }
        IMergeInputProvider compareToInputProvider = (IMergeInputProvider)compareToObject;
        if (this.getSequence() > compareToInputProvider.getSequence()) {
            return 1;
        }
        if (compareToInputProvider.getSequence() > this.getSequence()) {
            return -1;
        }
        return this.getText().compareTo(compareToInputProvider.getText());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hideDepth() {
        return true;
    }

    public boolean hideForce() {
        return false;
    }

    public boolean hideIgnoreAncestry() {
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public boolean showBestPracticesPage() {
        return true;
    }
}

