/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import com.vectrace.MercurialEclipse.wizards.SyncRepoWizard;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SyncRepoPage
extends HgWizardPage
implements IWizardPage {
    private Label locationLabel;
    private Combo locationCombo;
    private GridData locationData;
    private Label cloneParametersLabel;
    private Text cloneParameters;
    private GridData parameterData;
    private Label projectNameLabel;
    private Combo projectNameCombo;
    private GridData projectNameData;
    private boolean clone;
    String repoName;

    public SyncRepoPage(boolean clone, String pageName, String title, String description, String repoName, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.clone = clone;
        this.repoName = repoName;
        this.setDescription(description);
    }

    public SyncRepoPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getWizard().getNextPage((IWizardPage)this) != null;
    }

    public boolean isPageComplete() {
        if (this.clone) {
            return this.isPageComplete(this.locationCombo.getText(), this.projectNameCombo.getText());
        }
        return HgRepositoryLocation.validateLocation(this.locationCombo.getText());
    }

    private boolean isPageComplete(String url, String repoName1) {
        return HgRepositoryLocation.validateLocation(url) && repoName1.trim().length() > 0;
    }

    protected boolean isPageComplete(String url) {
        return HgRepositoryLocation.validateLocation(url);
    }

    private boolean validateAndSetComplete(String url, String repoName1) {
        boolean validLocation = this.isPageComplete(url, repoName1);
        ((SyncRepoWizard)this.getWizard()).setLocationUrl(validLocation ? url : null);
        ((SyncRepoWizard)this.getWizard()).setProjectName(validLocation ? repoName1 : null);
        this.setPageComplete(validLocation);
        return validLocation;
    }

    protected boolean validateAndSetComplete(String url) {
        boolean validLocation = this.isPageComplete(url);
        ((SyncRepoWizard)this.getWizard()).setLocationUrl(validLocation ? url : null);
        this.setPageComplete(validLocation);
        return validLocation;
    }

    public void createControl(Composite parent) {
        Composite outerContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        outerContainer.setLayout((Layout)layout);
        outerContainer.setLayoutData((Object)new GridData(768));
        this.locationLabel = new Label(outerContainer, 0);
        this.locationLabel.setText(Messages.getString("SyncRepoPage.locationLabel.text"));
        this.locationData = new GridData();
        this.locationData.widthHint = 300;
        this.locationCombo = new Combo(outerContainer, 4);
        this.locationCombo.setLayoutData((Object)this.locationData);
        this.locationCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SyncRepoPage.this.clone) {
                    SyncRepoPage.this.validateAndSetComplete(SyncRepoPage.this.locationCombo.getText(), SyncRepoPage.this.projectNameCombo.getText());
                } else {
                    SyncRepoPage.this.validateAndSetComplete(SyncRepoPage.this.getLocation());
                }
            }
        });
        this.locationCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (SyncRepoPage.this.clone) {
                    SyncRepoPage.this.validateAndSetComplete(SyncRepoPage.this.locationCombo.getText(), SyncRepoPage.this.projectNameCombo.getText());
                } else {
                    SyncRepoPage.this.validateAndSetComplete(SyncRepoPage.this.getLocation());
                }
            }
        });
        for (HgRepositoryLocation loc : MercurialEclipsePlugin.getRepoManager().getAllRepoLocations()) {
            this.locationCombo.add(loc.getLocation());
        }
        Button browseButton = new Button(outerContainer, 8);
        browseButton.setText(Messages.getString("SyncRepoPage.browseButton.text"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SyncRepoPage.this.getShell());
                dialog.setMessage(SyncRepoPage.this.getBrowseDialogMessage());
                String dir = dialog.open();
                if (dir != null) {
                    SyncRepoPage.this.locationCombo.setText(dir);
                }
            }
        });
        if (this.clone) {
            this.cloneParametersLabel = new Label(outerContainer, 0);
            this.cloneParametersLabel.setText(Messages.getString("SyncRepoPage.cloneParametersLabel.text"));
            this.cloneParameters = new Text(outerContainer, 2048);
            this.parameterData = new GridData();
            this.parameterData.widthHint = 285;
            this.parameterData.horizontalSpan = 2;
            this.cloneParameters.setLayoutData((Object)this.parameterData);
            this.cloneParameters.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((SyncRepoWizard)SyncRepoPage.this.getWizard()).setParameters(SyncRepoPage.this.cloneParameters.getText());
                }
            });
            this.projectNameLabel = new Label(outerContainer, 0);
            this.projectNameLabel.setText(Messages.getString("SyncRepoPage.projectNameLabel.text"));
            this.projectNameCombo = new Combo(outerContainer, 4);
            this.projectNameData = new GridData();
            this.projectNameData.widthHint = 300;
            this.projectNameData.horizontalSpan = 2;
            this.projectNameCombo.setLayoutData((Object)this.projectNameData);
            this.projectNameCombo.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SyncRepoPage.this.validateAndSetComplete(SyncRepoPage.this.getLocation(), SyncRepoPage.this.projectNameCombo.getText());
                }
            });
            this.projectNameCombo.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    SyncRepoPage.this.validateAndSetComplete(SyncRepoPage.this.getLocation(), SyncRepoPage.this.projectNameCombo.getText());
                }
            });
        } else {
            this.projectNameLabel = new Label(outerContainer, 0);
            this.projectNameLabel.setText(this.getProjectNameLabelText());
        }
        this.setControl((Control)outerContainer);
        this.setPageComplete(false);
    }

    protected String getProjectNameLabelText() {
        return String.valueOf(Messages.getString("SyncRepoPage.getProjectNameLabelText")) + this.repoName;
    }

    protected String getBrowseDialogMessage() {
        if (this.clone) {
            return Messages.getString("SyncRepoPage.browseDialogMessage.clone");
        }
        return Messages.getString("SyncRepoPage.browseDialogMessage.pullpush");
    }

    public void dispose() {
        this.locationLabel.dispose();
        this.locationCombo.dispose();
        if (this.cloneParametersLabel != null) {
            this.cloneParametersLabel.dispose();
        }
        if (this.projectNameLabel != null) {
            this.projectNameLabel.dispose();
        }
        if (this.projectNameCombo != null) {
            this.projectNameCombo.dispose();
        }
    }

    public String getLocation() {
        return this.locationCombo.getText();
    }
}

