/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ConfigurationWizardMainPage
extends HgWizardPage {
    protected boolean showCredentials = false;
    protected boolean showBundleButton = false;
    protected Combo userCombo;
    protected Text passwordText;
    protected Combo urlCombo;
    protected Button browseButton;
    protected Button browseFileButton;
    private static final int COMBO_HISTORY_LENGTH = 10;
    private static final String STORE_USERNAME_ID = "ConfigurationWizardMainPage.STORE_USERNAME_ID";

    public ConfigurationWizardMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private String[] addToHistory(String[] history, String newEntry, int limitHistory) {
        ArrayList<String> l = new ArrayList<String>();
        if (history != null) {
            l.addAll(Arrays.asList(history));
        }
        l.remove(newEntry);
        l.add(0, newEntry);
        if (l.size() > 10 && limitHistory > 0) {
            l.remove(10);
        }
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 1);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ConfigurationWizardMainPage.this.validateFields();
            }
        };
        this.createUrlControl(composite, listener);
        if (this.showCredentials) {
            this.createAuthenticationControl(composite, listener);
        }
        this.initializeValues();
        this.validateFields();
        this.urlCombo.setFocus();
        this.setControl((Control)composite);
    }

    private void createUrlControl(Composite composite, Listener listener) {
        Composite urlComposite = SWTWidgetHelper.createComposite(composite, 4);
        Group g = SWTWidgetHelper.createGroup(urlComposite, Messages.getString("ConfigurationWizardMainPage.urlGroup.title"), 4, 768);
        SWTWidgetHelper.createLabel((Composite)g, Messages.getString("ConfigurationWizardMainPage.urlLabel.text"));
        this.urlCombo = this.createEditableCombo((Composite)g);
        this.urlCombo.addListener(13, listener);
        this.urlCombo.addListener(24, listener);
        this.browseButton = SWTWidgetHelper.createPushButton((Composite)g, Messages.getString("ConfigurationWizardMainPage.browseButton.text"), 1);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ConfigurationWizardMainPage.this.getShell());
                dialog.setMessage(Messages.getString("ConfigurationWizardMainPage.dialog.message"));
                String dir = dialog.open();
                if (dir != null) {
                    ConfigurationWizardMainPage.this.getUrlCombo().setText(dir);
                }
            }
        });
        if (this.showBundleButton) {
            this.browseFileButton = SWTWidgetHelper.createPushButton((Composite)g, Messages.getString("PullPage.browseFileButton.text"), 1);
            this.browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(ConfigurationWizardMainPage.this.getShell());
                    dialog.setText(Messages.getString("PullPage.bundleDialog.text"));
                    String file = dialog.open();
                    if (file != null) {
                        ConfigurationWizardMainPage.this.getUrlCombo().setText(file);
                    }
                }
            });
        }
        this.urlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigurationWizardMainPage.this.setPageComplete(true);
            }
        });
        this.urlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    HgRepositoryLocation repo = MercurialEclipsePlugin.getRepoManager().getRepoLocation(ConfigurationWizardMainPage.this.urlCombo.getText());
                    String user = repo.getUser();
                    if (user != null && user.length() != 0) {
                        ConfigurationWizardMainPage.this.getUserCombo().setText(user);
                    } else {
                        ConfigurationWizardMainPage.this.getUserCombo().setText("");
                    }
                    String password = repo.getPassword();
                    if (password != null && password.length() != 0) {
                        ConfigurationWizardMainPage.this.getPasswordText().setText(password);
                    } else {
                        ConfigurationWizardMainPage.this.getPasswordText().setText("");
                    }
                }
                catch (URISyntaxException e1) {
                    MercurialEclipsePlugin.logError(e1);
                }
            }
        });
    }

    private void createAuthenticationControl(Composite composite, Listener listener) {
        Composite authComposite = SWTWidgetHelper.createComposite(composite, 2);
        Group g = SWTWidgetHelper.createGroup(authComposite, Messages.getString("ConfigurationWizardMainPage.authenticationGroup.title"));
        SWTWidgetHelper.createLabel((Composite)g, Messages.getString("ConfigurationWizardMainPage.userLabel.text"));
        this.userCombo = this.createEditableCombo((Composite)g);
        this.userCombo.addListener(13, listener);
        this.userCombo.addListener(24, listener);
        SWTWidgetHelper.createLabel((Composite)g, Messages.getString("ConfigurationWizardMainPage.passwordLabel.text"));
        this.passwordText = SWTWidgetHelper.createTextField((Composite)g);
        this.passwordText.setEchoChar('*');
    }

    protected Combo createEditableCombo(Composite parent) {
        Combo combo = new Combo(parent, 0);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public boolean finish(IProgressMonitor monitor) {
        Properties result = new Properties();
        if (this.showCredentials) {
            result.setProperty("user", this.userCombo.getText());
            result.setProperty("password", this.passwordText.getText());
        }
        result.setProperty("url", this.urlCombo.getText());
        this.properties = result;
        this.saveWidgetValues();
        return true;
    }

    private void initializeValues() {
        IDialogSettings setts = this.getDialogSettings();
        if (setts != null) {
            String[] userNames;
            String[] hostNames = this.updateHostNames();
            if (hostNames != null) {
                int i = 0;
                while (i < hostNames.length) {
                    this.urlCombo.add(hostNames[i]);
                    ++i;
                }
            }
            if (this.showCredentials && (userNames = setts.getArray(STORE_USERNAME_ID)) != null) {
                int i = 0;
                while (i < userNames.length) {
                    this.userCombo.add(userNames[i]);
                    ++i;
                }
            }
        }
        if (this.properties != null) {
            String host;
            if (this.showCredentials) {
                String password;
                String user = this.properties.getProperty("user");
                if (user != null) {
                    this.userCombo.setText(user);
                }
                if ((password = this.properties.getProperty("password")) != null) {
                    this.passwordText.setText(password);
                }
            }
            if ((host = this.properties.getProperty("url")) != null) {
                this.urlCombo.setText(host);
            }
        }
    }

    private void saveWidgetValues() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (this.settings != null && this.showCredentials) {
            String[] userNames = dialogSettings.getArray(STORE_USERNAME_ID);
            if (userNames == null) {
                userNames = new String[]{};
            }
            userNames = this.addToHistory(userNames, this.userCombo.getText(), 10);
            dialogSettings.put(STORE_USERNAME_ID, userNames);
        }
    }

    private String[] updateHostNames() {
        String[] newHostNames = new String[]{};
        Set<HgRepositoryLocation> repositories = MercurialEclipsePlugin.getRepoManager().getAllRepoLocations();
        if (repositories != null) {
            int i = 0;
            for (HgRepositoryLocation hgRepositoryLocation : repositories) {
                newHostNames = this.addToHistory(newHostNames, hgRepositoryLocation.getLocation(), -1);
                ++i;
            }
        }
        return newHostNames;
    }

    private void validateFields() {
        String url = this.urlCombo.getText();
        if (url.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.urlCombo != null) {
            this.urlCombo.setFocus();
        }
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage();
    }

    public boolean isShowCredentials() {
        return this.showCredentials;
    }

    public void setShowCredentials(boolean showCredentials) {
        this.showCredentials = showCredentials;
    }

    public Combo getUserCombo() {
        return this.userCombo;
    }

    public void setUserCombo(Combo userCombo) {
        this.userCombo = userCombo;
    }

    public Text getPasswordText() {
        return this.passwordText;
    }

    public void setPasswordText(Text passwordText) {
        this.passwordText = passwordText;
    }

    public Combo getUrlCombo() {
        return this.urlCombo;
    }

    public void setUrlCombo(Combo urlCombo) {
        this.urlCombo = urlCombo;
    }

    public boolean isShowBundleButton() {
        return this.showBundleButton;
    }

    public void setShowBundleButton(boolean showBundleButton) {
        this.showBundleButton = showBundleButton;
    }
}

