/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.views.console;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.views.console.ConsoleDocument;
import com.vectrace.MercurialEclipse.views.console.HgConsoleHolder;
import com.vectrace.MercurialEclipse.views.console.Messages;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class HgConsole
extends MessageConsole {
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private static final String HTTP_PATTERN_STRING = "[hH][tT][tT][pP].*[@]";
    private static final String HTTPS_PATTERN_STRING = "[hH][tT][tT][pP][sS].*[@]";
    private static final String SSH_PATTERN_STRING = "[sS][sS][hH].*[@]";
    private static final String SVN_PATTERN_STRING = "[sS][vV][nN].*[@]";
    private static final Pattern HTTP_PATTERN = Pattern.compile("[hH][tT][tT][pP].*[@]");
    private static final Pattern HTTPS_PATTERN = Pattern.compile("[hH][tT][tT][pP][sS].*[@]");
    private static final Pattern SSH_PATTERN = Pattern.compile("[sS][sS][hH].*[@]");
    private static final Pattern SVN_PATTERN = Pattern.compile("[sS][vV][nN].*[@]");
    private long commandStarted = 0L;
    private MessageConsoleStream commandStream;
    private MessageConsoleStream messageStream;
    private MessageConsoleStream errorStream;
    private ConsoleDocument document = new ConsoleDocument();
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("m:ss.SSS");
    private boolean visible = false;
    private boolean initialized = false;
    private static final String NESTING = "   ";

    public HgConsole() {
        super("Mercurial Console", MercurialEclipsePlugin.getImageDescriptor("icons/mercurialeclipse.png"));
    }

    protected void init() {
        super.init();
        this.initLimitOutput();
        this.initWrapSetting();
        this.initializeStreams();
        this.dump();
    }

    private void initWrapSetting() {
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("hg.console.wrap")) {
            this.setConsoleWidth(store.getInt("hg.console.width"));
        } else {
            this.setConsoleWidth(-1);
        }
    }

    private void initLimitOutput() {
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("hg.console.limitOutput")) {
            int highWaterMark = store.getInt("hg.console.highWaterMark");
            if (highWaterMark < 1000) {
                highWaterMark = 1000;
            }
            this.setWaterMarks(0, highWaterMark);
        } else {
            this.setWaterMarks(0, 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                this.commandStream = this.newMessageStream();
                this.errorStream = this.newMessageStream();
                this.messageStream = this.newMessageStream();
                this.commandColor = this.createColor(MercurialEclipsePlugin.getStandardDisplay(), "hg.console.command_color");
                this.commandStream.setColor(this.commandColor);
                this.messageColor = this.createColor(MercurialEclipsePlugin.getStandardDisplay(), "hg.console.message_color");
                this.messageStream.setColor(this.messageColor);
                this.errorColor = this.createColor(MercurialEclipsePlugin.getStandardDisplay(), "hg.console.error_color");
                this.errorStream.setColor(this.errorColor);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = true;
            ConsoleDocument.ConsoleLine[] lines = this.document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.appendLine(line.type, line.line);
                ++i;
            }
            this.document.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(int type, String line) {
        HgConsoleHolder.getInstance().showConsole();
        String myLine = line;
        myLine = HTTP_PATTERN.matcher(line).replaceAll("http://***@");
        if (myLine.equals(line)) {
            myLine = HTTPS_PATTERN.matcher(line).replaceAll("https://***@");
        }
        if (myLine.equals(line)) {
            myLine = SSH_PATTERN.matcher(line).replaceAll("ssh://***@");
        }
        if (myLine.equals(line)) {
            myLine = SVN_PATTERN.matcher(line).replaceAll("svn://***@");
        }
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                switch (type) {
                    case 0: {
                        this.commandStream.println(myLine);
                        break;
                    }
                    case 1: {
                        this.messageStream.println(myLine);
                        break;
                    }
                    case 2: {
                        this.errorStream.println(myLine);
                    }
                }
            } else {
                this.document.appendConsoleLine(type, myLine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
        }
    }

    public void shutdown() {
        super.dispose();
        if (this.commandColor != null) {
            this.commandColor.dispose();
        }
        if (this.messageColor != null) {
            this.messageColor.dispose();
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
    }

    public void commandInvoked(String line) {
        this.commandStarted = System.currentTimeMillis();
        this.appendLine(0, line);
    }

    public void messageLineReceived(String line, IStatus status) {
        this.appendLine(1, line);
    }

    public void errorLineReceived(String line, IStatus status) {
        this.appendLine(2, line);
    }

    public void commandCompleted(IStatus status, Throwable exception) {
        String time;
        long commandRuntime = System.currentTimeMillis() - this.commandStarted;
        try {
            time = String.valueOf(Messages.getString("HgConsole.doneIn")) + TIME_FORMAT.format(new Date(commandRuntime)) + Messages.getString("HgConsole.minutes");
        }
        catch (RuntimeException e) {
            MercurialEclipsePlugin.logError(e);
            time = Messages.getString("HgConsole.unknown");
        }
        if (status != null) {
            boolean includeRoot = true;
            if (status.getSeverity() == 4) {
                String statusText = String.valueOf(status.getMessage()) + "(" + time + ")";
                this.appendLine(2, statusText);
                includeRoot = false;
            } else {
                String statusText = time;
                this.appendLine(1, statusText);
            }
            this.outputStatus(status, includeRoot, includeRoot ? 0 : 1);
        } else if (exception != null) {
            String statusText = exception instanceof OperationCanceledException ? String.valueOf(Messages.getString("HgConsole.aborted1")) + time + Messages.getString("HgConsole.aborted2") : time;
            this.appendLine(0, statusText);
            if (exception instanceof CoreException) {
                this.outputStatus(((CoreException)exception).getStatus(), true, 1);
            }
        } else {
            this.appendLine(0, time);
        }
        this.appendLine(0, "");
    }

    private void outputStatus(IStatus status, boolean includeParent, int nestingLevel) {
        Throwable t;
        int myNestingLevel = nestingLevel;
        if (includeParent && !status.isOK()) {
            this.outputStatusMessage(status, nestingLevel);
            ++myNestingLevel;
        }
        if ((t = status.getException()) instanceof CoreException) {
            this.outputStatus(((CoreException)t).getStatus(), true, myNestingLevel);
        }
        IStatus[] children = status.getChildren();
        int i = 0;
        while (i < children.length) {
            this.outputStatus(children[i], true, myNestingLevel);
            ++i;
        }
    }

    private void outputStatusMessage(IStatus status, int nesting) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nesting) {
            buffer.append(NESTING);
            ++i;
        }
        buffer.append(this.messageLineForStatus(status));
        this.appendLine(0, buffer.toString());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.visible) {
            if (property.equals("hg.console.command_color")) {
                Color newColor = this.createColor(MercurialEclipsePlugin.getStandardDisplay(), "hg.console.command_color");
                this.commandStream.setColor(newColor);
                this.commandColor.dispose();
                this.commandColor = newColor;
            } else if (property.equals("hg.console.message_color")) {
                Color newColor = this.createColor(MercurialEclipsePlugin.getStandardDisplay(), "hg.console.message_color");
                this.messageStream.setColor(newColor);
                this.messageColor.dispose();
                this.messageColor = newColor;
            } else if (property.equals("hg.console.error_color")) {
                Color newColor = this.createColor(MercurialEclipsePlugin.getStandardDisplay(), "hg.console.error_color");
                this.errorStream.setColor(newColor);
                this.errorColor.dispose();
                this.errorColor = newColor;
            } else if (property.equals("hg.console.font")) {
                this.setFont(((FontRegistry)event.getSource()).get("hg.console.font"));
            }
        } else if (property.equals("hg.console.limitOutput")) {
            this.initLimitOutput();
        } else if (property.equals("hg.console.wrap")) {
            this.initWrapSetting();
        }
    }

    private String messageLineForStatus(IStatus status) {
        if (status.getSeverity() == 4) {
            return String.valueOf(Messages.getString("HgConsole.error")) + status.getMessage();
        }
        if (status.getSeverity() == 2) {
            return String.valueOf(Messages.getString("HgConsole.warning")) + status.getMessage();
        }
        if (status.getSeverity() == 1) {
            return String.valueOf(Messages.getString("HgConsole.info")) + status.getMessage();
        }
        return status.getMessage();
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MercurialEclipsePlugin.getDefault().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }
}

