/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.utils.ChangeSetNode;
import com.vectrace.MercurialEclipse.utils.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryGraph {
    private static RepositoryGraph instance = null;
    private Map<IResource, Map<String, ChangeSetNode>> revMap = new HashMap<IResource, Map<String, ChangeSetNode>>();
    private static AbstractCache cache = MercurialStatusCache.getInstance();

    private RepositoryGraph() {
    }

    public static RepositoryGraph getInstance() {
        if (instance == null) {
            instance = new RepositoryGraph();
        }
        return instance;
    }

    public ChangeSetNode getSubgraph(MercurialRevision base) {
        ChangeSet cs = cache.getChangeSet(base.getChangeSet().toString());
        Map<String, ChangeSetNode> nodes = this.revMap.get(base.getResource());
        if (nodes == null || nodes.size() == 0) {
            nodes = new HashMap<String, ChangeSetNode>();
            this.revMap.put(base.getResource(), nodes);
            ChangeSetNode baseNode = this.traverseGraph(base.getResource(), null, cs);
            nodes.put(cs.getChangeset(), baseNode);
            return baseNode;
        }
        return nodes.get(cs.getChangeset());
    }

    private ChangeSetNode traverseGraph(IResource res, ChangeSetNode father, ChangeSet cs) {
        if (cs == null) {
            throw new RuntimeException(Messages.getString("RepositoryGraph.changesetWasNull"));
        }
        Map<String, ChangeSetNode> nodes = this.revMap.get(res);
        ChangeSetNode csn = null;
        if (nodes.containsKey(cs.getChangeset())) {
            return csn;
        }
        List<String> parents = RepositoryGraph.getParentsForResource(res, cs);
        csn = new ChangeSetNode(cs, new ArrayList<ChangeSetNode>(), new ArrayList<ChangeSetNode>());
        if (father != null) {
            csn.getIncomingEdges().add(father);
        }
        nodes.put(cs.getChangeset(), csn);
        TreeSet<ChangeSetNode> edges = new TreeSet<ChangeSetNode>();
        int parCount = 0;
        while (parents != null && parCount < parents.size()) {
            ChangeSet parent = cache.getChangeSet(cs.getParents()[parCount]);
            if (parent != null) {
                ChangeSetNode edge = this.traverseGraph(res, father, parent);
                edges.add(edge);
            }
            ++parCount;
        }
        csn.getOutgoingEdges().addAll(edges);
        return csn;
    }

    public static List<String> getParentsForResource(IResource res, ChangeSet cs) {
        ArrayList<String> parents = new ArrayList<String>(2);
        if (cs.getParents() != null) {
            for (String string : parents) {
                if (string.charAt(0) == '-') continue;
                parents.add(string);
            }
        }
        return parents;
    }
}

