/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PatchUtils {
    public static final Pattern DIFF_START_PATTERN = Pattern.compile("^diff -r ", 8);

    public static IFilePatch[] getFilePatches(String outgoingPatch) throws HgException {
        if (outgoingPatch == null) {
            return new IFilePatch[0];
        }
        Matcher matcher = DIFF_START_PATTERN.matcher(outgoingPatch);
        if (matcher.find()) {
            String strippedPatch = outgoingPatch.substring(matcher.start(), outgoingPatch.length());
            try {
                return PatchUtils.createPatches(strippedPatch);
            }
            catch (CoreException e) {
                throw new HgException(e);
            }
        }
        return new IFilePatch[0];
    }

    public static IFilePatch[] createPatches(final String patch) throws CoreException {
        return ApplyPatchOperation.parsePatch((IStorage)new IStorage(){

            public InputStream getContents() throws CoreException {
                return new ByteArrayInputStream(patch.getBytes());
            }

            public IPath getFullPath() {
                return null;
            }

            public String getName() {
                return null;
            }

            public boolean isReadOnly() {
                return true;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        });
    }

    public static InputStream getPatchedContents(IFile file, IFilePatch[] patches, boolean reversed) throws CoreException {
        IFilePatch[] iFilePatchArray = patches;
        int n = patches.length;
        int n2 = 0;
        while (n2 < n) {
            IFilePatch patch = iFilePatchArray[n2];
            String[] headerWords = patch.getHeader().split(" ");
            String patchPath = headerWords[headerWords.length - 1].trim();
            if (file.getFullPath().toString().endsWith(patchPath)) {
                PatchConfiguration configuration = new PatchConfiguration();
                configuration.setReversed(reversed);
                IFilePatchResult patchResult = patch.apply((IStorage)file, configuration, null);
                return patchResult.getPatchedContents();
            }
            ++n2;
        }
        return file.getContents();
    }

    public static ResourceNode getResourceNodeFromInputStream(IResource resource, InputStream in) {
        PatchUtils patchUtils = new PatchUtils();
        patchUtils.getClass();
        return patchUtils.new PatchResourceNode(resource, in);
    }

    private class PatchResourceNode
    extends ResourceNode
    implements IStreamContentAccessor,
    ITypedElement {
        private InputStream in;

        public PatchResourceNode(IResource res, InputStream in) {
            super(res);
            this.in = in;
        }

        public InputStream getContents() throws CoreException {
            return this.in;
        }
    }
}

