/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.utils;

import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.cache.AbstractCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.utils.RepositoryGraph;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryPainterRevision
implements Comparable<HistoryPainterRevision> {
    private static AbstractCache cache = MercurialStatusCache.getInstance();
    private int lane;
    private int lanes;
    private ChangeSet changeSet;
    private List<HistoryPainterRevision> parents;
    private IResource resource;

    public HistoryPainterRevision(IResource res, ChangeSet changeSet) {
        this.changeSet = changeSet;
        this.parents = new ArrayList<HistoryPainterRevision>();
        this.resource = res;
        List<String> list = RepositoryGraph.getParentsForResource(res, changeSet);
        for (String string : list) {
            ChangeSet parent = cache.getChangeSet(string);
            if (parent == null) continue;
            this.parents.add(new HistoryPainterRevision(res, parent));
        }
    }

    HistoryPainterRevision() {
    }

    public int getLanes() {
        return this.lanes;
    }

    public void setLanes(int lanes) {
        this.lanes = lanes;
    }

    public int getLane() {
        return this.lane;
    }

    public void setLane(int lane) {
        this.lane = lane;
    }

    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    public int compareTo(HistoryPainterRevision o) {
        return o.getChangeSet().getChangesetIndex() - this.getChangeSet().getChangesetIndex();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.changeSet == null ? 0 : this.changeSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryPainterRevision)) {
            return false;
        }
        HistoryPainterRevision other = (HistoryPainterRevision)obj;
        return !(this.changeSet == null ? other.changeSet != null : !this.changeSet.equals(other.changeSet));
    }

    public List<HistoryPainterRevision> getParents() {
        return this.parents;
    }

    public void setParents(List<HistoryPainterRevision> parents) {
        this.parents = parents;
    }

    public String toString() {
        return String.valueOf(this.resource.getName()) + "," + this.changeSet.toString() + ",Lane:" + this.lane + ",Lanes:" + this.lanes + ",Parents:" + this.parents.size();
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }
}

