/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgIncomingClient;
import com.vectrace.MercurialEclipse.commands.HgOutgoingClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCache
extends Observable {
    protected static final Map<IProject, Set<IResource>> projectResources = new HashMap<IProject, Set<IResource>>();
    protected static final Map<String, ChangeSet> nodeMap = new TreeMap<String, ChangeSet>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResourcesToCache(IProject project, HgRepositoryLocation repositoryLocation, Map<HgRepositoryLocation, Map<IPath, SortedSet<ChangeSet>>> changeSetMap, ChangeSet.Direction direction) throws HgException {
        Map<IPath, SortedSet<ChangeSet>> resources;
        Map<IPath, SortedSet<ChangeSet>> removeMap = changeSetMap.get(repositoryLocation);
        if (removeMap != null) {
            removeMap.clear();
            changeSetMap.remove(repositoryLocation);
        }
        if ((resources = direction == ChangeSet.Direction.OUTGOING ? HgOutgoingClient.getOutgoing((IResource)project, repositoryLocation) : HgIncomingClient.getHgIncoming((IResource)project, repositoryLocation)) != null && resources.size() > 0) {
            for (Map.Entry<IPath, SortedSet<ChangeSet>> mapEntry : resources.entrySet()) {
                Map<IPath, SortedSet<ChangeSet>> map;
                IPath path = mapEntry.getKey();
                SortedSet<ChangeSet> changes = mapEntry.getValue();
                if (changes == null || changes.size() <= 0) continue;
                TreeSet<ChangeSet> revisions = new TreeSet<ChangeSet>();
                ChangeSet[] changeSets = changes.toArray(new ChangeSet[changes.size()]);
                if (changeSets != null) {
                    ChangeSet[] changeSetArray = changeSets;
                    int n = changeSets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ChangeSet changeSet = changeSetArray[n2];
                        revisions.add(changeSet);
                        if (direction == ChangeSet.Direction.INCOMING) {
                            Map<String, ChangeSet> map2 = nodeMap;
                            synchronized (map2) {
                                nodeMap.put(changeSet.toString(), changeSet);
                                nodeMap.put(changeSet.getChangeset(), changeSet);
                            }
                        }
                        ++n2;
                    }
                }
                if ((map = changeSetMap.get(repositoryLocation)) == null) {
                    map = new HashMap<IPath, SortedSet<ChangeSet>>();
                }
                map.put(path, revisions);
                changeSetMap.put(repositoryLocation, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToNodeMap(SortedSet<ChangeSet> changes) {
        for (ChangeSet changeSet : changes) {
            Map<String, ChangeSet> map = nodeMap;
            synchronized (map) {
                nodeMap.put(changeSet.toString(), changeSet);
                nodeMap.put(changeSet.getChangeset(), changeSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToProjectResources(IProject project, IResource member) {
        if (member.getType() == 4) {
            return;
        }
        Map<IProject, Set<IResource>> map = projectResources;
        synchronized (map) {
            Set<IResource> set = projectResources.get(project);
            if (set == null) {
                set = new HashSet<IResource>();
            }
            set.add(member);
            projectResources.put(project, set);
        }
    }

    public ChangeSet getChangeSet(String changeSet) {
        return nodeMap.get(changeSet);
    }

    public void notifyChanged(IResource resource) {
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.add(resource);
        this.notifyChanged(resources);
    }

    public void notifyChanged(Set<IResource> resources) {
        HashSet<IResource> set = new HashSet<IResource>();
        set.addAll(resources);
        for (IResource r : resources) {
            set.addAll(this.getMembers(r));
        }
        this.setChanged();
        this.notifyObservers(set);
    }

    protected Set<IResource> getMembers(IResource r) {
        HashSet<IResource> set = new HashSet<IResource>();
        if (r instanceof IContainer) {
            IContainer cont = (IContainer)r;
            try {
                IResource[] members = cont.members();
                if (members != null) {
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member instanceof IContainer) {
                            set.addAll(this.getMembers(member));
                        } else {
                            set.add(member);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
        set.add(r);
        return set;
    }

    protected Set<IResource> getMembers(IResource resource, Map<IPath, SortedSet<ChangeSet>> changeSets) {
        HashSet<IResource> members = new HashSet<IResource>();
        if (changeSets != null) {
            IWorkspaceRoot root = resource.getWorkspace().getRoot();
            for (IPath path : changeSets.keySet()) {
                IFile member = root.getFileForLocation(path);
                if (member == null || member.getType() == 2 || !resource.getLocation().isPrefixOf(member.getLocation())) continue;
                members.add((IResource)member);
            }
        }
        return members;
    }

    public IResource convertRepoRelPath(File hgRoot, IProject project, String repoRelPath) {
        String resourceLocation = String.valueOf(hgRoot.getAbsolutePath()) + File.separator + repoRelPath;
        Path path = new Path(resourceLocation);
        int equalSegments = path.matchingFirstSegments(project.getLocation());
        path = path.removeFirstSegments(equalSegments);
        IResource member = project.findMember((IPath)path);
        return member;
    }

    public static synchronized void clearNodeMap() {
        nodeMap.clear();
    }
}

