/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.HgRemoveClient;
import com.vectrace.MercurialEclipse.commands.HgRenameClient;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class HgMoveDeleteHook
implements IMoveDeleteHook {
    private boolean isInMercurialRepo(IFile file, IProgressMonitor monitor) {
        if (!MercurialUtilities.hgIsTeamProviderFor((IResource)file, false)) {
            return false;
        }
        try {
            return MercurialStatusCache.getInstance().isSupervised((IResource)file);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean folderHasMercurialFiles(IFolder folder, IProgressMonitor monitor) {
        if (!MercurialUtilities.hgIsTeamProviderFor((IResource)folder, false)) {
            return false;
        }
        try {
            IResource[] subtending = folder.members();
            int numResources = 0;
            while (true) {
                if (numResources >= subtending.length) {
                    return false;
                }
                if (subtending[numResources].getType() == 1 && subtending[numResources].exists() && this.isInMercurialRepo((IFile)subtending[numResources], monitor)) {
                    return true;
                }
                ++numResources;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        if (!this.isInMercurialRepo(file, monitor) || file.isDerived()) {
            return false;
        }
        return this.deleteHgFiles((IResource)file, monitor);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        if (!this.folderHasMercurialFiles(folder, monitor)) {
            return false;
        }
        return this.deleteHgFiles((IResource)folder, monitor);
    }

    private boolean deleteHgFiles(IResource resource, IProgressMonitor monitor) {
        try {
            HgRemoveClient.removeResource(resource, monitor);
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            return true;
        }
        return false;
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        if ((updateFlags & 4) != 0) {
            IFolder folder = project.getFolder(".hg");
            try {
                folder.delete(updateFlags, monitor);
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
                return true;
            }
        }
        return false;
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        if (!this.isInMercurialRepo(source, monitor)) {
            return false;
        }
        if (!this.moveHgFiles((IResource)source, (IResource)destination, monitor)) {
            return true;
        }
        tree.movedFile(source, destination);
        try {
            source.refreshLocal(2, monitor);
            destination.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
        }
        return true;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        if (!this.folderHasMercurialFiles(source, monitor)) {
            return false;
        }
        if (!this.moveHgFiles((IResource)source, (IResource)destination, monitor)) {
            return true;
        }
        tree.movedFolderSubtree(source, destination);
        try {
            source.refreshLocal(2, monitor);
            destination.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
        }
        return true;
    }

    private boolean moveHgFiles(IResource source, IResource destination, IProgressMonitor monitor) {
        try {
            HgRenameClient.renameResource(source, destination, monitor);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(Messages.getString("HgMoveDeleteHook.moveFailed")) + e.getMessage());
            return false;
        }
        try {
            source.refreshLocal(2, monitor);
            destination.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
        }
        return true;
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        return false;
    }
}

