/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.DecoratorImages;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.util.BitSet;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DecoratorStatus
extends LabelProvider
implements ILightweightLabelDecorator,
Observer {
    private static boolean folder_logic_2MM;
    private static MercurialStatusCache statusCache;

    public DecoratorStatus() {
        DecoratorStatus.configureFromPreferences();
        statusCache = MercurialStatusCache.getInstance();
        statusCache.addObserver(this);
    }

    private static void configureFromPreferences() {
        IPreferenceStore store = MercurialEclipsePlugin.getDefault().getPreferenceStore();
        folder_logic_2MM = "2-means-modified".equals(store.getString("hg.labeldecorator.logic"));
    }

    public static void refresh() {
        DecoratorStatus.configureFromPreferences();
    }

    public void decorate(Object element, IDecoration decoration) {
        BitSet output;
        IResource objectResource = (IResource)element;
        IProject objectProject = objectResource.getProject();
        if (objectProject == null || RepositoryProvider.getProvider((IProject)objectProject, (String)"com.vectrace.MercurialEclipse.team.MercurialTeamProvider") == null) {
            return;
        }
        if (!MercurialUtilities.hgIsTeamProviderFor(objectResource, true)) {
            return;
        }
        try {
            if (!statusCache.isStatusKnown(objectProject)) {
                statusCache.refreshStatus((IResource)objectProject, null);
            }
        }
        catch (TeamException ex) {
            MercurialEclipsePlugin.logError(ex);
            return;
        }
        try {
            output = statusCache.getStatus(objectResource);
        }
        catch (HgException e2) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e2));
            return;
        }
        ImageDescriptor overlay = null;
        String prefix = null;
        if (output != null) {
            if (folder_logic_2MM && (output.cardinality() > 2 || output.cardinality() == 2 && !output.get(0))) {
                overlay = DecoratorImages.modifiedDescriptor;
                prefix = ">";
            } else {
                switch (output.length() - 1) {
                    case 6: {
                        overlay = DecoratorImages.modifiedDescriptor;
                        prefix = ">";
                        break;
                    }
                    case 5: {
                        overlay = DecoratorImages.addedDescriptor;
                        prefix = ">";
                        break;
                    }
                    case 4: {
                        overlay = DecoratorImages.notTrackedDescriptor;
                        prefix = ">";
                        break;
                    }
                    case 1: {
                        overlay = DecoratorImages.managedDescriptor;
                        break;
                    }
                    case 3: {
                        overlay = DecoratorImages.removedDescriptor;
                        prefix = ">";
                        break;
                    }
                    case 2: {
                        overlay = DecoratorImages.deletedStillTrackedDescriptor;
                        prefix = ">";
                    }
                }
            }
        }
        if (overlay != null) {
            decoration.addOverlay(overlay);
        }
        ChangeSet cs = null;
        try {
            cs = IncomingChangesetCache.getInstance().getNewestIncomingChangeSet(objectResource);
        }
        catch (HgException e1) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e1));
        }
        if (cs != null) {
            prefix = prefix == null ? "<" : "<" + prefix;
        }
        if (prefix != null) {
            decoration.addPrefix(prefix);
        }
        try {
            ChangeSet changeSet = LocalChangesetCache.getInstance().getNewestLocalChangeSet(objectResource);
            if (changeSet != null) {
                String hex = ":" + changeSet.getNodeShort();
                String suffix = " [" + changeSet.getChangesetIndex() + hex + "]";
                if (objectResource.getType() == 1) {
                    suffix = " [" + changeSet.getChangesetIndex() + "] ";
                    if (cs != null) {
                        suffix = String.valueOf(suffix) + "< [" + cs.getChangesetIndex() + ":" + cs.getNodeShort() + " " + cs.getUser() + "]";
                    }
                }
                if (objectResource.getType() != 2) {
                    decoration.addSuffix(suffix);
                }
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logWarning(String.valueOf(Messages.getString("DecoratorStatus.couldntGetVersionOfResource")) + objectResource, (Throwable)((Object)e));
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void update(Observable o, Object updatedObject) {
        if (o == statusCache) {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            final String decoratorId = DecoratorStatus.class.getName();
            new SafeUiJob(Messages.getString("DecoratorStatus.updatingDecos")){

                protected IStatus runSafe(IProgressMonitor monitor) {
                    workbench.getDecoratorManager().update(decoratorId);
                    return super.runSafe(monitor);
                }
            }.schedule();
        }
    }
}

