/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ActionRemove
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IStructuredSelection selection;

    public void dispose() {
    }

    public void init(IWorkbenchWindow w) {
        this.window = w;
    }

    public void run(IAction action) {
        Shell shell;
        IProject proj = MercurialUtilities.getProject(this.selection);
        String Repository = MercurialUtilities.getRepositoryPath(proj);
        if (Repository == null) {
            Repository = ".";
        }
        if (this.window != null && this.window.getShell() != null) {
            shell = this.window.getShell();
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            shell = workbench.getActiveWorkbenchWindow().getShell();
        }
        String[] launchCmd = new String[]{MercurialUtilities.getHGExecutable(), "remove", "-Af", "--", ""};
        for (Object obj : this.selection) {
            IResource resource;
            if (!(obj instanceof IResource) || !MercurialUtilities.hgIsTeamProviderFor(resource = (IResource)obj, true)) continue;
            File workingDir = MercurialUtilities.getWorkingDir(resource);
            launchCmd[4] = MercurialUtilities.getResourceName(resource);
            if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("ActionRemove.removeFileQuestion"), (String)(String.valueOf(Messages.getString("ActionRemove.removeFileConfirmation")) + launchCmd[4] + Messages.getString("ActionRemove.removeFileConfirmation.2")))) continue;
            try {
                String output = MercurialUtilities.executeCommand(launchCmd, workingDir, false);
                if (output != null && output.length() != 0) {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.getString("ActionRemove.removeOutput"), (String)output);
                }
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
            }
            try {
                MercurialStatusCache.getInstance().refresh(proj);
            }
            catch (TeamException e) {
                MercurialEclipsePlugin.logError(Messages.getString("ActionRemove.unableToRefresh"), e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection in_selection) {
        if (in_selection != null && in_selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)in_selection;
        }
    }
}

