/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.history;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.OpenMercurialRevisionAction;
import com.vectrace.MercurialEclipse.commands.HgUpdateClient;
import com.vectrace.MercurialEclipse.history.ChangedPathsPage;
import com.vectrace.MercurialEclipse.history.GraphLogTableViewer;
import com.vectrace.MercurialEclipse.history.MercurialHistory;
import com.vectrace.MercurialEclipse.history.MercurialRevision;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.IStorageMercurialRevision;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.RefreshLocalChangesetsJob;
import com.vectrace.MercurialEclipse.team.cache.RefreshStatusJob;
import com.vectrace.MercurialEclipse.utils.CompareUtils;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.actions.ActionFactory;

public class MercurialHistoryPage
extends HistoryPage {
    private GraphLogTableViewer viewer;
    private IResource resource;
    private ChangeLogContentProvider changeLogViewContentProvider;
    private MercurialHistory mercurialHistory;
    private IFileRevision[] entries;
    private RefreshMercurialHistory refreshFileHistoryJob;
    private ChangedPathsPage changedPaths;

    public MercurialHistory getMercurialHistory() {
        return this.mercurialHistory;
    }

    public MercurialHistoryPage(IResource resource) {
        if (this.isValidInput(resource)) {
            this.resource = resource;
        }
    }

    public boolean inputSet() {
        this.mercurialHistory = new MercurialHistory(this.resource);
        this.refresh();
        return true;
    }

    public void createControl(Composite parent) {
        this.changedPaths = new ChangedPathsPage(this, parent);
        this.createTableHistory(this.changedPaths.getControl());
        this.changedPaths.createControl();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new Action(){

            public void run() {
                MercurialHistoryPage.this.copyToClipboard();
            }
        });
    }

    private void createTableHistory(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout0 = new GridLayout();
        layout0.marginHeight = 0;
        layout0.marginWidth = 0;
        composite.setLayout((Layout)layout0);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        this.viewer = new GraphLogTableViewer(composite, 268501762, this);
        Table changeLogTable = this.viewer.getTable();
        changeLogTable.setLinesVisible(true);
        changeLogTable.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        changeLogTable.setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        changeLogTable.setLayout((Layout)layout);
        TableColumn column = new TableColumn(changeLogTable, 0x1000000);
        column.setText(Messages.getString("MercurialHistoryPage.columnHeader.graph"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, true));
        column = new TableColumn(changeLogTable, 16384);
        column.setText(Messages.getString("MercurialHistoryPage.columnHeader.changeset"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, true));
        column = new TableColumn(changeLogTable, 16384);
        column.setText(Messages.getString("MercurialHistoryPage.columnHeader.tag"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        column = new TableColumn(changeLogTable, 16384);
        column.setText(Messages.getString("MercurialHistoryPage.columnHeader.branch"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        column = new TableColumn(changeLogTable, 16384);
        column.setText(Messages.getString("MercurialHistoryPage.columnHeader.user"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(7, true));
        column = new TableColumn(changeLogTable, 16384);
        column.setText(Messages.getString("MercurialHistoryPage.columnHeader.date"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(13, true));
        column = new TableColumn(changeLogTable, 16384);
        column.setText(Messages.getString("MercurialHistoryPage.columnHeader.summary"));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ChangeSetLabelProvider());
        this.changeLogViewContentProvider = new ChangeLogContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.changeLogViewContentProvider);
        this.contributeActions();
    }

    private void copyToClipboard() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator iterator = selection.iterator();
        StringBuilder text = new StringBuilder();
        int columnIndex = 1;
        while (columnIndex < this.viewer.getTable().getColumnCount()) {
            text.append(this.viewer.getTable().getColumn(columnIndex).getText()).append('\t');
            ++columnIndex;
        }
        text.append(System.getProperty("line.separator"));
        while (iterator.hasNext()) {
            Object next = iterator.next();
            ITableLabelProvider labelProvider = (ITableLabelProvider)this.viewer.getLabelProvider();
            int columnIndex2 = 1;
            while (columnIndex2 < this.viewer.getTable().getColumnCount()) {
                text.append(labelProvider.getColumnText(next, columnIndex2)).append('\t');
                ++columnIndex2;
            }
            text.append(System.getProperty("line.separator"));
        }
        new Clipboard(this.getSite().getShell().getDisplay()).setContents((Object[])new String[]{text.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    private void contributeActions() {
        final OpenMercurialRevisionAction openAction = this.getOpenAction();
        final Action compareAction = this.getCompareAction();
        final Action updateAction = new Action(Messages.getString("MercurialHistoryPage.updateAction.name")){
            private MercurialRevision rev;

            public void run() {
                try {
                    IProject project = MercurialHistoryPage.this.resource.getProject();
                    Assert.isNotNull((Object)project);
                    HgUpdateClient.update(project, this.rev.getChangeSet().getChangeset(), true);
                    project.setPersistentProperty(ResourceProperties.MERGING, null);
                    project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
                    new RefreshStatusJob(Messages.getString("MercurialHistoryPage.refreshJob.name"), project).schedule();
                    new RefreshLocalChangesetsJob((IResource)project).schedule();
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }

            public boolean isEnabled() {
                IStructuredSelection selection = (IStructuredSelection)MercurialHistoryPage.this.viewer.getSelection();
                Object[] revs = selection.toArray();
                if (revs != null && revs.length == 1) {
                    this.rev = (MercurialRevision)((Object)revs[0]);
                    return true;
                }
                return false;
            }
        };
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr1) {
                menuMgr1.add((IContributionItem)new Separator("group.file"));
                menuMgr1.add((IAction)openAction);
                if (MercurialHistoryPage.this.resource == null || MercurialHistoryPage.this.resource.getType() != 1) {
                    openAction.setEnabled(false);
                } else {
                    openAction.setEnabled(true);
                }
                compareAction.setEnabled(compareAction.isEnabled());
                menuMgr1.add((IAction)compareAction);
                updateAction.setEnabled(updateAction.isEnabled());
                menuMgr1.add((IAction)updateAction);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.viewer.getTable().setMenu(menu);
    }

    private OpenMercurialRevisionAction getOpenAction() {
        final OpenMercurialRevisionAction openAction = new OpenMercurialRevisionAction("Open");
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                openAction.selectionChanged((IStructuredSelection)MercurialHistoryPage.this.viewer.getSelection());
            }
        });
        openAction.setPage(this);
        return openAction;
    }

    private Action getCompareAction() {
        return new Action(Messages.getString("CompareAction.label")){

            public void run() {
                try {
                    IStorageMercurialRevision secondSelection = this.getStorage(1);
                    boolean localEditable = secondSelection == null;
                    CompareUtils.openEditor(this.getStorage(0), secondSelection, false, localEditable);
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }

            public boolean isEnabled() {
                int size = ((IStructuredSelection)MercurialHistoryPage.this.viewer.getSelection()).size();
                return IFile.class.isAssignableFrom(MercurialHistoryPage.this.getInput().getClass()) && (size == 1 || size == 2);
            }

            private IStorageMercurialRevision getStorage(int i) throws CoreException {
                IStructuredSelection selection = (IStructuredSelection)MercurialHistoryPage.this.viewer.getSelection();
                Object[] revs = selection.toArray();
                if (i >= revs.length) {
                    return null;
                }
                MercurialRevision rev = (MercurialRevision)((Object)revs[i]);
                return (IStorageMercurialRevision)rev.getStorage(null);
            }
        };
    }

    public Control getControl() {
        return this.changedPaths.getControl();
    }

    public void setFocus() {
    }

    public String getDescription() {
        return this.resource.getFullPath().toOSString();
    }

    public String getName() {
        return this.resource.getFullPath().toOSString();
    }

    public boolean isValidInput(Object object) {
        return true;
    }

    public void refresh() {
        if (this.refreshFileHistoryJob == null) {
            this.refreshFileHistoryJob = new RefreshMercurialHistory(Integer.MAX_VALUE, this.mercurialHistory);
        }
        if (this.refreshFileHistoryJob.getState() != 0) {
            this.refreshFileHistoryJob.cancel();
        }
        this.refreshFileHistoryJob.setFileHistory(this.mercurialHistory);
        this.refreshFileHistoryJob.schedule();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public TableViewer getTableViewer() {
        return this.viewer;
    }

    class ChangeLogContentProvider
    implements IStructuredContentProvider {
        ChangeLogContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            MercurialHistoryPage.this.entries = null;
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (MercurialHistoryPage.this.entries != null) {
                return MercurialHistoryPage.this.entries;
            }
            IFileHistory fileHistory = (IFileHistory)parent;
            MercurialHistoryPage.this.entries = fileHistory.getFileRevisions();
            return MercurialHistoryPage.this.entries;
        }
    }

    class ChangeSetLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ChangeSetLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String ret;
            if (!(obj instanceof MercurialRevision)) {
                return "Type Error";
            }
            MercurialRevision mercurialFileRevision = (MercurialRevision)((Object)obj);
            ChangeSet changeSet = mercurialFileRevision.getChangeSet();
            switch (index) {
                case 1: {
                    ret = changeSet.toString();
                    break;
                }
                case 2: {
                    ret = changeSet.getTag();
                    break;
                }
                case 3: {
                    ret = changeSet.getBranch();
                    break;
                }
                case 4: {
                    ret = changeSet.getUser();
                    break;
                }
                case 5: {
                    ret = changeSet.getDate();
                    break;
                }
                case 6: {
                    ret = changeSet.getSummary();
                    break;
                }
                default: {
                    ret = null;
                }
            }
            return ret;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class RefreshMercurialHistory
    extends Job {
        MercurialHistory mercurialHistory;
        private int from;

        public RefreshMercurialHistory(int from, MercurialHistory fileHistory) {
            super("Fetching Mercurial revisions...");
            this.from = from;
            this.mercurialHistory = fileHistory;
        }

        public void setFileHistory(MercurialHistory mercurialHistory) {
            this.mercurialHistory = mercurialHistory;
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            if (this.mercurialHistory != null) {
                try {
                    this.mercurialHistory.refresh(monitor, this.from);
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                }
                final Runnable runnable = new Runnable(){

                    public void run() {
                        MercurialHistoryPage.this.viewer.setInput((Object)RefreshMercurialHistory.this.mercurialHistory);
                    }
                };
                if (MercurialHistoryPage.this.viewer == null) {
                    return status;
                }
                final Control ctrl = MercurialHistoryPage.this.viewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!ctrl.isDisposed()) {
                                BusyIndicator.showWhile((Display)ctrl.getDisplay(), (Runnable)runnable);
                            }
                        }
                    });
                }
            }
            return status;
        }
    }
}

