/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.StatusContainerAction;
import com.vectrace.MercurialEclipse.dialogs.CommitResource;
import com.vectrace.MercurialEclipse.dialogs.Messages;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.Team;

public final class CommitResourceUtil {
    private final HgRoot root;

    public CommitResourceUtil(HgRoot root) {
        this.root = root;
    }

    public CommitResource[] getCommitResources(IResource[] inResources) {
        StatusContainerAction statusAction = new StatusContainerAction(null, inResources);
        File workingDir = statusAction.getWorkingDir();
        try {
            statusAction.run();
            String result = statusAction.getResult();
            return this.spliceList(result, workingDir, inResources);
        }
        catch (Exception e) {
            String msg = "HgRoot: " + this.root.getAbsolutePath() + Messages.getString("CommitResourceUtil.error.unableToGetStatus") + e.getMessage();
            MercurialEclipsePlugin.logError(msg, e);
            return null;
        }
    }

    private CommitResource[] spliceList(String string, File workingDir, IResource[] inResources) {
        ArrayList<CommitResource> list = new ArrayList<CommitResource>();
        StringTokenizer st = new StringTokenizer(string);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        while (st.hasMoreTokens()) {
            String status = st.nextToken(" ").trim();
            String fileName = st.nextToken("\n").trim();
            IResource statusResource = null;
            int res = 0;
            while (res < inResources.length) {
                try {
                    statusResource = MercurialUtilities.convert(String.valueOf(workingDir.getCanonicalPath()) + File.separator + fileName);
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                }
                if (statusResource == null) {
                    // empty if block
                }
                ++res;
            }
            if (statusResource == null) {
                try {
                    Path rootPath = new Path(this.root.getCanonicalPath());
                    Path filePath = new Path(fileName);
                    IFolder folder = workspaceRoot.getFolder((IPath)rootPath);
                    statusResource = folder.getFile((IPath)filePath);
                }
                catch (IOException e) {
                    MercurialEclipsePlugin.logError(e);
                }
            }
            if (status.startsWith("?") && Team.isIgnoredHint(statusResource)) continue;
            list.add(new CommitResource(status, statusResource, new File(fileName)));
        }
        return list.toArray(new CommitResource[0]);
    }
}

