/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.model.Signature;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgSigsClient
extends AbstractClient {
    public static List<Signature> getSigs(File repoFile) throws HgException {
        try {
            HgRoot root = new HgRoot(MercurialTeamProvider.getHgRoot(repoFile).getCanonicalPath());
            ArrayList<Signature> nodes = new ArrayList<Signature>();
            File sigFile = new File(root.getCanonicalPath().concat(File.separator).concat(".hgsigs"));
            if (sigFile.exists()) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new LineNumberReader(new FileReader(sigFile));
                        String line = ((LineNumberReader)reader).readLine();
                        while (line != null) {
                            String nodeId = line.substring(0, line.indexOf(" 0 "));
                            Signature sig = new Signature(null, nodeId, root);
                            nodes.add(sig);
                            line = ((LineNumberReader)reader).readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new HgException(e.getLocalizedMessage(), e);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            return nodes;
        }
        catch (Exception e) {
            MercurialEclipsePlugin.logError(e);
            throw new HgException(e.getLocalizedMessage(), e);
        }
    }

    public static String checkSig(File file, String nodeId) throws HgException {
        HgCommand c = new HgCommand("sigcheck", HgSigsClient.getWorkingDirectory(file), false);
        c.setUsePreferenceTimeout("hg.timeout.default");
        c.addOptions(nodeId);
        return c.executeToString();
    }
}

