/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.GpgCommand;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;

public class HgSignClient {
    public static String sign(File directory, ChangeSet cs, String key, String message, String user, boolean local, boolean force, boolean noCommit, String passphrase) throws HgException {
        HgCommand command = new HgCommand("sign", directory, true);
        File file = new File("me.gpg.tmp");
        String cmd = "gpg.cmd=".concat(MercurialUtilities.getGpgExecutable(true)).concat(" --batch --no-tty --armor");
        if (passphrase != null && passphrase.length() > 0) {
            FileWriter fw = null;
            try {
                try {
                    fw = new FileWriter(file);
                    fw.write(passphrase.concat("\n"));
                    fw.flush();
                    cmd = cmd.concat(" --passphrase-file ").concat(file.getCanonicalFile().getCanonicalPath());
                }
                catch (IOException e) {
                    throw new HgException(e.getMessage());
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Exception e) {
                        MercurialEclipsePlugin.logError(e);
                    }
                }
            }
        }
        command.addOptions("-k", key, "--config", cmd);
        if (local) {
            command.addOptions("-l");
        }
        if (force) {
            command.addOptions("-f");
        }
        if (noCommit) {
            command.addOptions("--no-commit");
        } else {
            command.addOptions("-m", message, "-u", user);
        }
        command.addOptions(cs.getChangeset());
        try {
            String result;
            String string = result = command.executeToString();
            return string;
        }
        finally {
            if (!file.delete()) {
                throw new HgException(String.valueOf(file.getName()) + " could not be deleted.");
            }
        }
    }

    public static String getPrivateKeyList() throws HgException {
        ArrayList<String> getKeysCmd = new ArrayList<String>();
        getKeysCmd.add(MercurialUtilities.getGpgExecutable(true));
        getKeysCmd.add("--list-secret-keys");
        GpgCommand command = new GpgCommand(getKeysCmd, ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), false);
        return new String(command.executeToBytes());
    }
}

