/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.File;

public class HgRebaseClient
extends AbstractClient {
    public static String rebase(File repoResource, int sourceRev, int baseRev, int destRev, boolean collapse, boolean cont, boolean abort) throws HgException {
        HgCommand c = new HgCommand("rebase", HgRebaseClient.getWorkingDirectory(repoResource), false);
        c.setUsePreferenceTimeout("hg.timeout.pull");
        c.addOptions("--config", "extensions.hgext.rebase=");
        if (!cont && !abort) {
            if (sourceRev >= 0 && baseRev <= 0) {
                c.addOptions("--source", "" + sourceRev);
            }
            if (sourceRev < 0 && baseRev >= 0) {
                c.addOptions("--base", "" + baseRev);
            }
            if (destRev >= 0) {
                c.addOptions("--dest", "" + destRev);
            }
            if (collapse) {
                c.addOptions("--collapse");
            }
        }
        if (cont && !abort) {
            c.addOptions("--continue");
        }
        if (abort && !cont) {
            c.addOptions("--abort");
        }
        return c.executeToString();
    }
}

