/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import java.io.File;

public class HgAtticClient
extends AbstractClient {
    public static String shelve(File repoFile, String commitMessage, boolean git, String user, String name) throws HgException {
        HgCommand cmd = new HgCommand("attic-shelve", HgAtticClient.getWorkingDirectory(repoFile), false);
        if (commitMessage != null && commitMessage.length() > 0) {
            cmd.addOptions("-m", commitMessage);
        }
        if (git) {
            cmd.addOptions("--git");
        }
        if (user != null && user.length() > 0) {
            cmd.addOptions("-u", user);
        }
        cmd.addOptions("--currentdate", name);
        return cmd.executeToString();
    }

    public static String unshelve(File repoFile, boolean guessRenamedFiles, boolean delete, String name) throws HgException {
        HgCommand cmd = new HgCommand("attic-unshelve", HgAtticClient.getWorkingDirectory(repoFile), false);
        if (guessRenamedFiles) {
            cmd.addOptions("--similarity");
        }
        if (delete) {
            cmd.addOptions("--delete");
        }
        cmd.addOptions(name);
        return cmd.executeToString();
    }

    public static String refresh(File repoFile, String name) throws HgException {
        HgCommand cmd = new HgCommand("shelve", HgAtticClient.getWorkingDirectory(repoFile), false);
        cmd.addOptions("--refresh", name);
        return cmd.executeToString();
    }
}

