/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Insertable;

public class ObjectAddress
implements Insertable {
    public static final int Size = 4;
    public static ObjectAddress Null = new ObjectAddress(0, 0);
    private static final int PageNumberOffset = 0;
    private static final int ObjectNumberOffset = 3;
    private int pageNumber;
    private int objectNumber;

    public ObjectAddress(byte[] b) throws IllegalArgumentException {
        if (b.length != 4) {
            throw new IllegalArgumentException();
        }
        Buffer buf = new Buffer(b);
        this.pageNumber = buf.getUInt(0, 3);
        this.objectNumber = buf.getUInt(3, 1);
    }

    public ObjectAddress(int pageNumber, int objectNumber) throws IllegalArgumentException {
        if (pageNumber == 0 && objectNumber == 0) {
            this.pageNumber = 0;
            this.objectNumber = 0;
            return;
        }
        if (pageNumber < 0 || pageNumber > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        if (pageNumber % 8192 == 0) {
            throw new IllegalArgumentException();
        }
        if (objectNumber < 0 || objectNumber > 255) {
            throw new IllegalArgumentException();
        }
        this.pageNumber = pageNumber;
        this.objectNumber = objectNumber;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof ObjectAddress)) {
            return false;
        }
        ObjectAddress address = (ObjectAddress)anObject;
        if (this.pageNumber != address.pageNumber) {
            return false;
        }
        return this.objectNumber == address.objectNumber;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int hashCode() {
        return this.pageNumber << 8 | this.objectNumber;
    }

    public boolean isNull() {
        return this.pageNumber == 0 && this.objectNumber == 0;
    }

    public byte[] toByteArray() {
        Buffer buf = new Buffer(4);
        buf.put(0, 3, this.pageNumber);
        buf.put(3, 1, this.objectNumber);
        return buf.get();
    }
}

