/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.CollectionTypesSupportExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinMetaModelExt
extends BuiltinMetaModel {
    public static final String ORDEREDSET = "OrderedSet";
    public static final String BAG = "Bag";
    public static final String COLLECTION = "Collection";
    private static CollectionTypesSupportExt collectionTypesExt = new CollectionTypesSupportExt();

    static {
        collectionTypesExt.init(XECORE);
    }

    public static final boolean isListType(EClassifier classifier) {
        return classifier.getName().endsWith("List");
    }

    public static final boolean isSetType(EClassifier classifier) {
        return classifier.getName().endsWith("Set") && !BuiltinMetaModelExt.isOrderedSetType(classifier);
    }

    public static final boolean isOrderedSetType(EClassifier classifier) {
        return classifier.getName().endsWith(ORDEREDSET);
    }

    public static final boolean isBagType(EClassifier classifier) {
        return classifier.getName().endsWith(BAG);
    }

    public static final boolean isAbstractCollectionType(EClassifier classifier) {
        return classifier.getName().endsWith(COLLECTION);
    }

    public static EClass getBagType(EClassifier innerType) {
        return collectionTypesExt.getBagType(innerType);
    }

    public static EClass getOrderedSetType(EClassifier innerType) {
        return collectionTypesExt.getOrderedSetType(innerType);
    }

    public static EClass replaceCollectionElementType(EClassifier collectionType, EClassifier newElementType) {
        if (BuiltinMetaModelExt.isListType(collectionType)) {
            return BuiltinMetaModelExt.getListType(newElementType);
        }
        if (BuiltinMetaModelExt.isSetType(collectionType)) {
            return BuiltinMetaModelExt.getSetType(newElementType);
        }
        if (BuiltinMetaModelExt.isOrderedSetType(collectionType)) {
            return BuiltinMetaModelExt.getOrderedSetType(newElementType);
        }
        if (BuiltinMetaModelExt.isBagType(collectionType)) {
            return BuiltinMetaModelExt.getBagType(newElementType);
        }
        return BuiltinMetaModelExt.getCollectionType(newElementType);
    }

    public static EClassifier getCommonSuperType(Collection<EClassifier> elementTypes) {
        if (elementTypes.size() == 0) {
            return BuiltinMetaModel.VOID;
        }
        Iterator<EClassifier> it = elementTypes.iterator();
        EClassifier superType = it.next();
        while (it.hasNext()) {
            superType = BuiltinMetaModelExt.getCommonSuperType(superType, it.next());
        }
        return superType;
    }

    public static EClassifier getCommonSuperType(EClassifier type1, EClassifier type2) {
        if (BuiltinMetaModel.VOID == type1) {
            return type2;
        }
        if (BuiltinMetaModel.isAssignableFrom(type1, type2)) {
            return type1;
        }
        if (type1 instanceof EClass) {
            EClass eClass = (EClass)type1;
            for (EClass nextSuperType : BuiltinMetaModelExt.getAllSuperTypes(eClass)) {
                if (!BuiltinMetaModel.isAssignableFrom((EClassifier)nextSuperType, type2)) continue;
                return nextSuperType;
            }
        }
        return EcorePackage.eINSTANCE.getEJavaObject();
    }

    private static List<EClass> getAllSuperTypes(EClass eClass) {
        ArrayList<EClass> result = new ArrayList<EClass>((Collection<EClass>)eClass.getESuperTypes());
        int i = 0;
        while (i < result.size()) {
            EClass nextSuperType = (EClass)result.get(i);
            result.addAll((Collection<EClass>)nextSuperType.getESuperTypes());
            ++i;
        }
        return result;
    }
}

