/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.wizards;

import com.collabnet.subversion.merge.Activator;
import com.collabnet.subversion.merge.Messages;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.history.ILogEntry;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.SVNUrlWithPegRevision;
import org.tigris.subversion.subclipse.ui.dialogs.ChooseUrlDialog;
import org.tigris.subversion.subclipse.ui.dialogs.HistoryDialog;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MergeWizardAdvancedPage
extends WizardPage {
    private Combo fromCombo;
    private Button selectFromButton;
    private Button fromHeadButton;
    private Button fromRevisionButton;
    private Text fromRevisionText;
    private Button selectFromRevisionButton;
    private Button useFromButton;
    private Combo toCombo;
    private Button selectToButton;
    private Button toHeadButton;
    private Button toRevisionButton;
    private Text toRevisionText;
    private Button selectToRevisionButton;
    private IResource resource;
    private IResource[] resources;
    private ISVNLocalResource svnResource;
    private SVNUrl fromUrl;
    private SVNRevision fromRevision;
    private SVNUrl toUrl;
    private SVNRevision toRevision;
    private String[] urlStrings;
    private String commonRoot;
    private MergeResource[] mergeResources;
    private Table fromTable;
    private TableViewer fromViewer;
    private Label toResourcesLabel;
    private Table toTable;
    private TableViewer toViewer;
    private String[] columnHeaders = new String[]{Messages.MergeWizardAdvancedPage_resource};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true)};

    public MergeWizardAdvancedPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        MergeWizard wizard = (MergeWizard)this.getWizard();
        this.resource = wizard.getResource();
        this.resources = wizard.getResources();
        if (this.resource != null) {
            this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)this.resource);
        }
        Composite outerContainer = new Composite(parent, 0);
        outerContainer.setLayout((Layout)new GridLayout());
        outerContainer.setLayoutData((Object)new GridData(1808));
        Group fromGroup = new Group(outerContainer, 0);
        fromGroup.setText(Messages.MergeWizardAdvancedPage_from);
        GridLayout fromLayout = new GridLayout();
        fromLayout.numColumns = 5;
        fromGroup.setLayout((Layout)fromLayout);
        fromGroup.setLayoutData((Object)new GridData(1808));
        this.fromCombo = new Combo((Composite)fromGroup, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        this.fromCombo.setLayoutData((Object)data);
        if (this.resources != null) {
            this.commonRoot = this.getCommonRoot();
            if (this.commonRoot != null) {
                this.fromCombo.setText(this.commonRoot);
            }
        }
        this.selectFromButton = new Button((Composite)fromGroup, 8);
        this.selectFromButton.setText(Messages.MergeWizardAdvancedPage_select);
        if (this.resources != null && this.resources.length > 1) {
            Label label = new Label((Composite)fromGroup, 0);
            label.setText(Messages.MergeWizardAdvancedPage_resources);
            data = new GridData();
            data.horizontalSpan = 5;
            label.setLayoutData((Object)data);
            this.fromTable = new Table((Composite)fromGroup, 2816);
            this.fromTable.setLinesVisible(false);
            this.fromTable.setHeaderVisible(false);
            data = new GridData(768);
            data.heightHint = 75;
            data.horizontalSpan = 5;
            this.fromTable.setLayoutData((Object)data);
            TableLayout tableLayout = new TableLayout();
            this.fromTable.setLayout((Layout)tableLayout);
            this.fromViewer = new TableViewer(this.fromTable);
            this.fromViewer.setContentProvider((IContentProvider)new MergeContentProvider());
            ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
            this.fromViewer.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)new MergeLabelProvider(0), decorator));
            int i = 0;
            while (i < this.columnHeaders.length) {
                tableLayout.addColumnData(this.columnLayouts[i]);
                TableColumn tc = new TableColumn(this.fromTable, 0, i);
                tc.setResizable(this.columnLayouts[i].resizable);
                tc.setText(this.columnHeaders[i]);
                ++i;
            }
            this.fromViewer.setInput((Object)this);
        }
        this.fromHeadButton = new Button((Composite)fromGroup, 16);
        this.fromHeadButton.setText(Messages.MergeWizardAdvancedPage_headRevision);
        this.fromRevisionButton = new Button((Composite)fromGroup, 16);
        this.fromRevisionButton.setText(Messages.MergeWizardAdvancedPage_revision);
        this.fromRevisionButton.setSelection(true);
        this.fromRevisionText = new Text((Composite)fromGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.fromRevisionText.setLayoutData((Object)data);
        this.selectFromRevisionButton = new Button((Composite)fromGroup, 8);
        this.selectFromRevisionButton.setText(Messages.MergeWizardAdvancedPage_select2);
        Group toGroup = new Group(outerContainer, 0);
        toGroup.setText(Messages.MergeWizardAdvancedPage_to);
        GridLayout toLayout = new GridLayout();
        toLayout.numColumns = 5;
        toGroup.setLayout((Layout)toLayout);
        toGroup.setLayoutData((Object)new GridData(1808));
        this.useFromButton = new Button((Composite)toGroup, 32);
        this.useFromButton.setText(Messages.MergeWizardAdvancedPage_useFrom);
        data = new GridData();
        data.horizontalSpan = 5;
        this.useFromButton.setLayoutData((Object)data);
        this.useFromButton.setSelection(true);
        this.toCombo = new Combo((Composite)toGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 4;
        this.toCombo.setLayoutData((Object)data);
        this.toCombo.setVisible(false);
        this.toCombo.setText(this.fromCombo.getText());
        this.selectToButton = new Button((Composite)toGroup, 8);
        this.selectToButton.setText(Messages.MergeWizardAdvancedPage_select3);
        this.selectToButton.setVisible(false);
        if (this.resources != null && this.resources.length > 1) {
            this.toResourcesLabel = new Label((Composite)toGroup, 0);
            this.toResourcesLabel.setText(Messages.MergeWizardAdvancedPage_resources);
            data = new GridData();
            data.horizontalSpan = 5;
            this.toResourcesLabel.setLayoutData((Object)data);
            this.toResourcesLabel.setVisible(false);
            this.toTable = new Table((Composite)toGroup, 2816);
            this.toTable.setLinesVisible(false);
            this.toTable.setHeaderVisible(false);
            data = new GridData(768);
            data.heightHint = 75;
            data.horizontalSpan = 5;
            this.toTable.setLayoutData((Object)data);
            TableLayout tableLayout = new TableLayout();
            this.toTable.setLayout((Layout)tableLayout);
            this.toViewer = new TableViewer(this.toTable);
            this.toViewer.setContentProvider((IContentProvider)new MergeContentProvider());
            ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
            this.toViewer.setLabelProvider((IBaseLabelProvider)new TableDecoratingLabelProvider((ILabelProvider)new MergeLabelProvider(1), decorator));
            int i = 0;
            while (i < this.columnHeaders.length) {
                tableLayout.addColumnData(this.columnLayouts[i]);
                TableColumn tc = new TableColumn(this.toTable, 0, i);
                tc.setResizable(this.columnLayouts[i].resizable);
                tc.setText(this.columnHeaders[i]);
                ++i;
            }
            this.toViewer.setInput((Object)this);
            this.toTable.setVisible(false);
        }
        this.toHeadButton = new Button((Composite)toGroup, 16);
        this.toHeadButton.setText(Messages.MergeWizardAdvancedPage_headRevision2);
        this.toRevisionButton = new Button((Composite)toGroup, 16);
        this.toRevisionButton.setText(Messages.MergeWizardAdvancedPage_revision2);
        this.toRevisionButton.setSelection(true);
        this.toRevisionText = new Text((Composite)toGroup, 2048);
        data = new GridData();
        data.widthHint = 40;
        this.toRevisionText.setLayoutData((Object)data);
        this.selectToRevisionButton = new Button((Composite)toGroup, 8);
        this.selectToRevisionButton.setText(Messages.MergeWizardAdvancedPage_select4);
        SelectionListener selectionListener = this.getSelectionListener();
        this.selectFromButton.addSelectionListener(selectionListener);
        this.fromHeadButton.addSelectionListener(selectionListener);
        this.fromRevisionButton.addSelectionListener(selectionListener);
        this.selectFromRevisionButton.addSelectionListener(selectionListener);
        this.useFromButton.addSelectionListener(selectionListener);
        this.selectToButton.addSelectionListener(selectionListener);
        this.toHeadButton.addSelectionListener(selectionListener);
        this.toRevisionButton.addSelectionListener(selectionListener);
        this.selectToRevisionButton.addSelectionListener(selectionListener);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() == MergeWizardAdvancedPage.this.fromCombo && MergeWizardAdvancedPage.this.useFromButton.getSelection()) {
                    MergeWizardAdvancedPage.this.toCombo.setText(MergeWizardAdvancedPage.this.fromCombo.getText());
                }
                if (e.getSource() == MergeWizardAdvancedPage.this.fromCombo && MergeWizardAdvancedPage.this.fromViewer != null) {
                    MergeWizardAdvancedPage.this.fromViewer.refresh();
                }
                if (e.getSource() == MergeWizardAdvancedPage.this.toCombo && MergeWizardAdvancedPage.this.toViewer != null) {
                    MergeWizardAdvancedPage.this.toViewer.refresh();
                }
                MergeWizardAdvancedPage.this.setPageComplete(MergeWizardAdvancedPage.this.canFinish());
            }
        };
        this.fromCombo.addModifyListener(modifyListener);
        this.toCombo.addModifyListener(modifyListener);
        this.fromRevisionText.addModifyListener(modifyListener);
        this.toRevisionText.addModifyListener(modifyListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.fromRevisionText.addFocusListener((FocusListener)focusListener);
        this.toRevisionText.addFocusListener((FocusListener)focusListener);
        this.setPageComplete(this.canFinish());
        this.setMessage(Messages.MergeWizardAdvancedPage_message);
        this.setControl((Control)outerContainer);
    }

    private SelectionListener getSelectionListener() {
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == MergeWizardAdvancedPage.this.selectFromButton) {
                    ChooseUrlDialog dialog = new ChooseUrlDialog(MergeWizardAdvancedPage.this.getShell(), MergeWizardAdvancedPage.this.resource);
                    dialog.setIncludeBranchesAndTags(MergeWizardAdvancedPage.this.resources.length == 1);
                    if (dialog.open() == 0 && dialog.getUrl() != null) {
                        MergeWizardAdvancedPage.this.fromCombo.setText(dialog.getUrl());
                        if (MergeWizardAdvancedPage.this.useFromButton.getSelection()) {
                            MergeWizardAdvancedPage.this.toCombo.setText(dialog.getUrl());
                        }
                    }
                } else if (e.getSource() == MergeWizardAdvancedPage.this.fromHeadButton || e.getSource() == MergeWizardAdvancedPage.this.fromRevisionButton) {
                    MergeWizardAdvancedPage.this.fromRevisionText.setEnabled(MergeWizardAdvancedPage.this.fromRevisionButton.getSelection());
                    MergeWizardAdvancedPage.this.selectFromRevisionButton.setEnabled(MergeWizardAdvancedPage.this.fromRevisionButton.getSelection());
                    if (MergeWizardAdvancedPage.this.fromRevisionButton.getSelection()) {
                        MergeWizardAdvancedPage.this.fromRevisionText.setFocus();
                    }
                } else if (e.getSource() == MergeWizardAdvancedPage.this.selectFromRevisionButton) {
                    MergeWizardAdvancedPage.this.showLog(MergeWizardAdvancedPage.this.fromRevisionText);
                } else if (e.getSource() == MergeWizardAdvancedPage.this.useFromButton) {
                    if (MergeWizardAdvancedPage.this.useFromButton.getSelection()) {
                        MergeWizardAdvancedPage.this.toCombo.setText(MergeWizardAdvancedPage.this.fromCombo.getText());
                    }
                    MergeWizardAdvancedPage.this.toCombo.setVisible(!MergeWizardAdvancedPage.this.useFromButton.getSelection());
                    MergeWizardAdvancedPage.this.selectToButton.setVisible(!MergeWizardAdvancedPage.this.useFromButton.getSelection());
                    if (MergeWizardAdvancedPage.this.toResourcesLabel != null) {
                        MergeWizardAdvancedPage.this.toResourcesLabel.setVisible(!MergeWizardAdvancedPage.this.useFromButton.getSelection());
                    }
                    if (MergeWizardAdvancedPage.this.toTable != null) {
                        MergeWizardAdvancedPage.this.toTable.setVisible(!MergeWizardAdvancedPage.this.useFromButton.getSelection());
                    }
                } else if (e.getSource() == MergeWizardAdvancedPage.this.selectToButton) {
                    ChooseUrlDialog dialog = new ChooseUrlDialog(MergeWizardAdvancedPage.this.getShell(), MergeWizardAdvancedPage.this.resource);
                    dialog.setIncludeBranchesAndTags(MergeWizardAdvancedPage.this.resources.length == 1);
                    if (dialog.open() == 0 && dialog.getUrl() != null) {
                        MergeWizardAdvancedPage.this.toCombo.setText(dialog.getUrl());
                    }
                } else if (e.getSource() == MergeWizardAdvancedPage.this.toHeadButton || e.getSource() == MergeWizardAdvancedPage.this.toRevisionButton) {
                    MergeWizardAdvancedPage.this.toRevisionText.setEnabled(MergeWizardAdvancedPage.this.toRevisionButton.getSelection());
                    MergeWizardAdvancedPage.this.selectToRevisionButton.setEnabled(MergeWizardAdvancedPage.this.toRevisionButton.getSelection());
                    if (MergeWizardAdvancedPage.this.toRevisionButton.getSelection()) {
                        MergeWizardAdvancedPage.this.toRevisionText.setFocus();
                    }
                } else if (e.getSource() == MergeWizardAdvancedPage.this.selectToRevisionButton) {
                    MergeWizardAdvancedPage.this.showLog(MergeWizardAdvancedPage.this.toRevisionText);
                }
                MergeWizardAdvancedPage.this.setPageComplete(MergeWizardAdvancedPage.this.canFinish());
            }
        };
        return selectionListener;
    }

    private boolean canFinish() {
        this.setErrorMessage(null);
        if (this.fromCombo.getText().trim().length() == 0) {
            return false;
        }
        if (!this.validateUrl(this.fromCombo.getText().trim())) {
            this.setErrorMessage(Messages.MergeWizardAdvancedPage_invalidFromUrl);
            return false;
        }
        if (!this.useFromButton.getSelection() && this.toCombo.getText().trim().length() == 0) {
            return false;
        }
        if (!this.useFromButton.getSelection() && !this.validateUrl(this.toCombo.getText().trim())) {
            this.setErrorMessage(Messages.MergeWizardAdvancedPage_invalidToUrl);
            return false;
        }
        if (this.fromRevisionButton.getSelection() && this.fromRevisionText.getText().trim().length() == 0) {
            return false;
        }
        if (this.fromRevisionButton.getSelection() && !this.validateRevision(this.fromRevisionText.getText().trim())) {
            this.setErrorMessage(Messages.MergeWizardAdvancedPage_invalidFromRevision);
            return false;
        }
        if (this.toRevisionButton.getSelection() && this.toRevisionText.getText().trim().length() == 0) {
            return false;
        }
        if (this.toRevisionButton.getSelection() && !this.validateRevision(this.toRevisionText.getText().trim())) {
            this.setErrorMessage(Messages.MergeWizardAdvancedPage_invalidToRevision);
            return false;
        }
        return true;
    }

    private String getUrl(String url) {
        if (url != null) {
            try {
                SVNUrlWithPegRevision svnUrlWithPegRevision = new SVNUrlWithPegRevision(new SVNUrl(url));
                SVNUrl svnUrl = svnUrlWithPegRevision.getUrl();
                if (svnUrl != null) {
                    return svnUrl.toString();
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return url;
    }

    private void showLog(Text text) {
        ISVNRemoteFile remoteResource = null;
        if (text == this.fromRevisionText) {
            try {
                this.fromUrl = new SVNUrl(this.getUrl(this.getFrom()));
                remoteResource = this.svnResource.getRepository().getRemoteFile(this.fromUrl);
            }
            catch (Exception e) {
                Activator.handleError(Messages.MergeWizardAdvancedPage_showLogError, e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.MergeWizardAdvancedPage_showLog, (String)e.toString());
                return;
            }
            if (remoteResource == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.MergeWizardAdvancedPage_showLog, (String)(String.valueOf(Messages.MergeWizardAdvancedPage_invalidUrl) + this.getFrom()));
                return;
            }
        }
        if (text == this.toRevisionText) {
            try {
                this.toUrl = new SVNUrl(this.getUrl(this.getTo()));
                remoteResource = this.svnResource.getRepository().getRemoteFile(this.toUrl);
            }
            catch (Exception e) {
                Activator.handleError(Messages.MergeWizardAdvancedPage_showLogError, e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.MergeWizardAdvancedPage_showLog, (String)e.toString());
                return;
            }
            if (remoteResource == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.MergeWizardAdvancedPage_showLog, (String)(String.valueOf(Messages.MergeWizardAdvancedPage_invalidUrl) + this.getTo()));
                return;
            }
        }
        HistoryDialog dialog = null;
        dialog = text == this.fromRevisionText || text == this.toRevisionText ? new HistoryDialog(this.getShell(), remoteResource) : new HistoryDialog(this.getShell(), this.resource);
        if (dialog.open() == 1) {
            return;
        }
        ILogEntry[] selectedEntries = dialog.getSelectedLogEntries();
        if (selectedEntries.length == 0) {
            return;
        }
        if (text != null && this.useFromButton.getSelection()) {
            this.fromRevisionText.setText(Long.toString(selectedEntries[selectedEntries.length - 1].getRevision().getNumber() - 1L));
            this.fromRevisionButton.setSelection(true);
            this.fromHeadButton.setSelection(false);
            this.toRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.toRevisionButton.setSelection(true);
            this.toHeadButton.setSelection(false);
            this.fromRevisionText.setEnabled(true);
            this.toRevisionText.setEnabled(true);
            return;
        }
        if (text == this.fromRevisionText || text == null && this.fromRevisionText.getText().trim().length() == 0) {
            this.fromRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.fromRevisionButton.setSelection(true);
            this.fromHeadButton.setSelection(false);
            this.fromRevisionText.setEnabled(true);
        }
        if (text == this.toRevisionText) {
            this.toRevisionText.setText(Long.toString(selectedEntries[0].getRevision().getNumber()));
            this.toRevisionButton.setSelection(true);
            this.toHeadButton.setSelection(false);
            this.toRevisionText.setEnabled(true);
        }
    }

    private boolean validateUrl(String url) {
        if (!url.startsWith("/")) {
            try {
                new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return true;
    }

    private boolean validateRevision(String revision) {
        try {
            SVNRevision.getRevision((String)revision);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IResource[] getResources() {
        return this.resources;
    }

    private String getFrom() {
        if (this.fromCombo.getText().startsWith("/")) {
            return String.valueOf(this.svnResource.getRepository().getUrl().toString()) + this.fromCombo.getText().trim();
        }
        return this.fromCombo.getText().trim();
    }

    public SVNUrl getFromUrl() {
        try {
            this.fromUrl = new SVNUrl(this.getFrom());
        }
        catch (MalformedURLException e) {
            Activator.handleError(e);
        }
        return this.fromUrl;
    }

    public SVNUrl[] getFromUrls() {
        if (this.resources.length == 1) {
            SVNUrl[] urls = new SVNUrl[]{this.getFromUrl()};
            return urls;
        }
        SVNUrl[] urls = new SVNUrl[this.mergeResources.length];
        int i = 0;
        while (i < this.mergeResources.length) {
            try {
                urls[i] = this.getFrom().endsWith("/") ? new SVNUrl(String.valueOf(this.getFrom()) + this.mergeResources[i].getPartialPath()) : new SVNUrl(String.valueOf(this.getFrom()) + "/" + this.mergeResources[i].getPartialPath());
            }
            catch (MalformedURLException e) {
                Activator.handleError(e);
            }
            ++i;
        }
        return urls;
    }

    private String getTo() {
        if (this.toCombo.getText().startsWith("/")) {
            return String.valueOf(this.svnResource.getRepository().getUrl().toString()) + this.toCombo.getText().trim();
        }
        return this.toCombo.getText().trim();
    }

    public SVNUrl getToUrl() {
        try {
            this.toUrl = new SVNUrl(this.getTo());
        }
        catch (MalformedURLException e) {
            Activator.handleError(e);
        }
        return this.toUrl;
    }

    public SVNUrl[] getToUrls() {
        if (this.resources.length == 1) {
            SVNUrl[] urls = new SVNUrl[]{this.getToUrl()};
            return urls;
        }
        SVNUrl[] urls = new SVNUrl[this.mergeResources.length];
        int i = 0;
        while (i < this.mergeResources.length) {
            try {
                urls[i] = this.getTo().endsWith("/") ? new SVNUrl(String.valueOf(this.getTo()) + this.mergeResources[i].getPartialPath()) : new SVNUrl(String.valueOf(this.getTo()) + "/" + this.mergeResources[i].getPartialPath());
            }
            catch (MalformedURLException e) {
                Activator.handleError(e);
            }
            ++i;
        }
        return urls;
    }

    public SVNRevision getFromRevision() {
        if (this.fromHeadButton.getSelection()) {
            this.fromRevision = SVNRevision.HEAD;
        } else {
            try {
                this.fromRevision = SVNRevision.getRevision((String)this.fromRevisionText.getText().trim());
            }
            catch (ParseException e) {
                Activator.handleError(e);
            }
        }
        return this.fromRevision;
    }

    public SVNRevision getToRevision() {
        if (this.toHeadButton.getSelection()) {
            this.toRevision = SVNRevision.HEAD;
        } else {
            try {
                this.toRevision = SVNRevision.getRevision((String)this.toRevisionText.getText().trim());
            }
            catch (ParseException e) {
                Activator.handleError(e);
            }
        }
        return this.toRevision;
    }

    private String getCommonRoot() {
        this.commonRoot = ((MergeWizard)this.getWizard()).getCommonRoot();
        this.urlStrings = ((MergeWizard)this.getWizard()).getUrlStrings();
        this.mergeResources = new MergeResource[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            this.mergeResources[i] = this.urlStrings[i].length() <= this.commonRoot.length() ? new MergeResource(this.resources[i], this.commonRoot) : new MergeResource(this.resources[i], this.urlStrings[i].substring(this.commonRoot.length() + 1));
            ++i;
        }
        return this.commonRoot;
    }

    class MergeContentProvider
    implements IStructuredContentProvider {
        MergeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return MergeWizardAdvancedPage.this.mergeResources;
        }
    }

    class MergeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        private int type;
        public static final int FROM = 0;
        public static final int TO = 1;

        public MergeLabelProvider(int type) {
            this.type = type;
        }

        public String getColumnText(Object element, int columnIndex) {
            return this.getText(element);
        }

        public String getText(Object element) {
            MergeResource mergeResource = (MergeResource)element;
            if (this.type == 0) {
                return String.valueOf(mergeResource.getPartialPath()) + " [" + MergeWizardAdvancedPage.this.fromCombo.getText() + "/" + mergeResource.getPartialPath() + "]";
            }
            return String.valueOf(mergeResource.getPartialPath()) + " [" + MergeWizardAdvancedPage.this.toCombo.getText() + "/" + mergeResource.getPartialPath() + "]";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.getImage(element);
        }

        public Image getImage(Object element) {
            MergeResource mergeResource = (MergeResource)element;
            return this.workbenchLabelProvider.getImage((Object)mergeResource.getResource());
        }
    }

    private class MergeResource
    implements IAdaptable {
        private IResource resource;
        private String partialPath;

        public MergeResource(IResource resource, String partialPath) {
            this.resource = resource;
            this.partialPath = partialPath;
        }

        public IResource getResource() {
            return this.resource;
        }

        public void setResource(IResource resource) {
            this.resource = resource;
        }

        public String getPartialPath() {
            return this.partialPath;
        }

        public void setPartialPath(String partialPath) {
            this.partialPath = partialPath;
        }

        public Object getAdapter(Class adapter) {
            if (IResource.class == adapter) {
                return this.resource;
            }
            return null;
        }
    }

    class TableDecoratingLabelProvider
    extends DecoratingLabelProvider
    implements ITableLabelProvider {
        ITableLabelProvider provider;
        ILabelDecorator decorator;

        public TableDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator) {
            super(provider, decorator);
            this.provider = (ITableLabelProvider)provider;
            this.decorator = decorator;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image decorated;
            Image image = this.provider.getColumnImage(element, columnIndex);
            if (this.decorator != null && (decorated = this.decorator.decorateImage(image, element)) != null) {
                return decorated;
            }
            return image;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = this.provider.getColumnText(element, columnIndex);
            return text;
        }
    }
}

