/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.ecore.edit.commands.EcoreCreateShortcutDecorationsCommand;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.ecore.part.EcoreElementChooserDialog;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateShortcutAction
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedElement;
        IEditorPart diagramEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        Shell shell = diagramEditor.getEditorSite().getShell();
        assert (diagramEditor instanceof DiagramEditor);
        TransactionalEditingDomain editingDomain = ((DiagramEditor)diagramEditor).getEditingDomain();
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        assert (selection instanceof IStructuredSelection);
        assert (((IStructuredSelection)selection).size() == 1);
        assert (((IStructuredSelection)selection).getFirstElement() instanceof EditPart);
        EditPart selectedDiagramPart = (EditPart)((IStructuredSelection)selection).getFirstElement();
        View view = (View)selectedDiagramPart.getModel();
        EcoreElementChooserDialog elementChooser = new EcoreElementChooserDialog(shell, view);
        int result = elementChooser.open();
        if (result != 0) {
            return null;
        }
        URI selectedModelElementURI = elementChooser.getSelectedModelElementURI();
        try {
            selectedElement = editingDomain.getResourceSet().getEObject(selectedModelElementURI, true);
        }
        catch (WrappedException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Exception while loading object: " + selectedModelElementURI.toString(), e);
            return null;
        }
        if (selectedElement == null) {
            return null;
        }
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new EObjectAdapter(selectedElement), Node.class, null, EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        CreateCommand command = new CreateCommand(editingDomain, viewDescriptor, view);
        command = command.compose((IUndoableOperation)new EcoreCreateShortcutDecorationsCommand(editingDomain, view, viewDescriptor));
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to create shortcut", e);
        }
        return null;
    }
}

