/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.wizards;

import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.ui.CommitFilesChooser;
import com.vectrace.MercurialEclipse.ui.LocationChooser;
import com.vectrace.MercurialEclipse.ui.SWTWidgetHelper;
import com.vectrace.MercurialEclipse.wizards.HgWizardPage;
import com.vectrace.MercurialEclipse.wizards.Messages;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportPage
extends HgWizardPage
implements Listener {
    protected final List<IResource> resources;
    private HgRoot root;
    private CommitFilesChooser commitFiles;
    private LocationChooser locationChooser;

    public ExportPage(List<IResource> resources, HgRoot root) {
        super(Messages.getString("ExportWizard.pageName"), Messages.getString("ExportWizard.pageTitle"), null);
        this.resources = resources;
        this.root = root;
    }

    protected boolean validatePage() {
        String msg = this.locationChooser.validate();
        if (msg == null && this.getCheckedResources().size() == 0) {
            msg = Messages.getString("ExportWizard.InvalidPathFile");
        }
        if (msg == null) {
            this.setMessage(null);
        }
        this.setErrorMessage(msg);
        this.setPageComplete(msg == null);
        return msg == null;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTWidgetHelper.createComposite(parent, 1);
        Group group = SWTWidgetHelper.createGroup(composite, Messages.getString("ExportWizard.PathLocation"));
        this.locationChooser = new LocationChooser((Composite)group, true, this.getDialogSettings());
        this.locationChooser.addStateListener(this);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        this.locationChooser.setLayoutData(data);
        this.commitFiles = new CommitFilesChooser(composite, true, this.resources, this.root, false);
        this.commitFiles.setLayoutData(new GridData(1808));
        this.commitFiles.addStateListener(this);
        this.setControl((Control)composite);
        this.validatePage();
    }

    public List<IResource> getCheckedResources() {
        return this.commitFiles.getCheckedResources(new String[0]);
    }

    public void handleEvent(Event event) {
        this.validatePage();
    }

    public LocationChooser.Location getLocation() {
        return this.locationChooser.getCheckedLocation();
    }

    @Override
    public boolean finish(IProgressMonitor monitor) {
        this.locationChooser.saveSettings();
        return super.finish(monitor);
    }
}

