/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team.cache;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.cache.IncomingChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.LocalChangesetCache;
import com.vectrace.MercurialEclipse.team.cache.MercurialStatusCache;
import com.vectrace.MercurialEclipse.team.cache.Messages;
import com.vectrace.MercurialEclipse.team.cache.OutgoingChangesetCache;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public final class RefreshJob
extends SafeWorkspaceJob {
    private static final MercurialStatusCache mercurialStatusCache = MercurialStatusCache.getInstance();
    private final HgRepositoryLocation repositoryLocation;
    private final IProject project;
    private boolean withFiles = false;

    public RefreshJob(String name, HgRepositoryLocation repositoryLocation, IProject project, boolean withFiles) {
        super(name);
        this.repositoryLocation = repositoryLocation;
        this.project = project;
        this.withFiles = withFiles;
    }

    public RefreshJob(String name, HgRepositoryLocation repositoryLocation, IProject project) {
        super(name);
        this.repositoryLocation = repositoryLocation;
        this.project = project;
        this.withFiles = Boolean.valueOf(HgClients.getPreference("hg.performance.fileShowsChangeset", "false"));
    }

    protected IStatus runSafe(IProgressMonitor monitor) {
        try {
            mercurialStatusCache.refreshStatus((IResource)this.project, monitor);
        }
        catch (HgException e1) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e1));
        }
        if (monitor != null) {
            monitor.subTask(Messages.getString("RefreshJob.UpdatingStatusAndVersionCache"));
        }
        try {
            if (monitor != null) {
                monitor.subTask(Messages.getString("RefreshJob.LoadingLocalRevisions"));
            }
            LocalChangesetCache.getInstance().refreshAllLocalRevisions((IResource)this.project, true, this.withFiles);
            if (monitor != null) {
                monitor.worked(1);
            }
            if (this.repositoryLocation != null) {
                if (monitor != null) {
                    monitor.subTask(String.valueOf(Messages.getString("RefreshJob.LoadingIncomingRevisions")) + this.repositoryLocation);
                }
                IncomingChangesetCache.getInstance().refreshIncomingChangeSets(this.project, this.repositoryLocation);
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask(String.valueOf(Messages.getString("RefreshJob.LoadingOutgoingRevisionsFor")) + this.repositoryLocation);
                }
                OutgoingChangesetCache.getInstance().refreshOutgoingChangeSets(this.project, this.repositoryLocation);
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask(Messages.getString("RefreshJob.AddingRemoteRepositoryToProjectRepositories"));
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
        }
        catch (HgException e) {
            MercurialEclipsePlugin.logError((Throwable)((Object)e));
        }
        return super.runSafe(monitor);
    }
}

