/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.team;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeWorkspaceJob;
import com.vectrace.MercurialEclipse.dialogs.RevertDialog;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.Messages;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionRevert
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IStructuredSelection selection;
    private HgRoot root;

    public void dispose() {
    }

    public void init(IWorkbenchWindow w) {
        this.window = w;
    }

    public void run(IAction action) {
        try {
            this.root = null;
            ArrayList<IResource> resources = new ArrayList<IResource>();
            for (Object obj : this.selection.toList()) {
                if (!(obj instanceof IResource)) continue;
                IResource resource = (IResource)obj;
                boolean merging = resource.getProject().getPersistentProperty(ResourceProperties.MERGING) != null;
                boolean supervised = MercurialUtilities.hgIsTeamProviderFor(resource, false);
                if (!supervised || merging) continue;
                resources.add(resource);
                if (this.root != null) continue;
                this.root = MercurialTeamProvider.getHgRoot(resource);
            }
            if (resources.size() != 0) {
                RevertDialog chooser = new RevertDialog(Display.getCurrent().getActiveShell(), this.root);
                chooser.setFiles(resources);
                if (chooser.open() == 0) {
                    final List<IResource> result = chooser.getSelection();
                    new SafeWorkspaceJob(Messages.getString("ActionRevert.revertFiles")){

                        protected IStatus runSafe(IProgressMonitor monitor) {
                            ActionRevert.this.doRevert(monitor, result);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            } else {
                Shell shell;
                if (this.window != null && this.window.getShell() != null) {
                    shell = this.window.getShell();
                } else {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    shell = workbench.getActiveWorkbenchWindow().getShell();
                }
                MessageDialog.openInformation((Shell)shell, (String)Messages.getString("ActionRevert.HgRevert"), (String)Messages.getString("ActionRevert.noFilesToRevert"));
            }
        }
        catch (CoreException e) {
            MercurialEclipsePlugin.logError(e);
            MercurialEclipsePlugin.showError(e);
        }
    }

    public void doRevert(IProgressMonitor monitor, List<IResource> resources) {
        String[] launchCmd = new String[]{MercurialUtilities.getHGExecutable(), "revert", "--no-backup", "--", ""};
        monitor.beginTask(Messages.getString("ActionRevert.revertingResources"), resources.size() * 2);
        for (IResource resource : resources) {
            if (monitor.isCanceled()) break;
            File workingDir = resource.getParent().getLocation().toFile();
            launchCmd[4] = resource.getName();
            try {
                monitor.subTask(String.valueOf(Messages.getString("ActionRevert.reverting")) + resource.getName() + "...");
                MercurialUtilities.executeCommand(launchCmd, workingDir, true);
                monitor.worked(1);
            }
            catch (HgException e) {
                MercurialEclipsePlugin.logError((Throwable)((Object)e));
            }
        }
        for (IResource resource : resources) {
            monitor.subTask(String.valueOf(Messages.getString("ActionRevert.refreshing")) + resource.getName() + "...");
            try {
                resource.refreshLocal(1, monitor);
            }
            catch (CoreException e) {
                MercurialEclipsePlugin.logError(e);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public void selectionChanged(IAction action, ISelection in_selection) {
        if (in_selection != null && in_selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)in_selection;
        }
    }
}

