/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.synchronize.actions;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.commands.HgPushPullClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.synchronize.MercurialSynchronizeParticipant;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

public class PullRepositorySynchronizeOperation
extends SynchronizeModelOperation {
    private IProject project;
    private ISynchronizePageConfiguration configuration;
    private MercurialSynchronizeParticipant participant;
    private boolean update;

    public PullRepositorySynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, IResource[] resources, boolean update) {
        super(configuration, elements);
        this.project = resources[0].getProject();
        this.configuration = configuration;
        this.participant = (MercurialSynchronizeParticipant)this.configuration.getParticipant();
        this.update = update;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Starting pull from " + this.project + ". Update: " + this.update, 1);
        new SafeUiJob("Pulling..."){

            protected IStatus runSafe(IProgressMonitor moni) {
                try {
                    HgRepositoryLocation loc = PullRepositorySynchronizeOperation.this.participant.getRepositoryLocation();
                    if (loc != null) {
                        HgPushPullClient.pull((IResource)PullRepositorySynchronizeOperation.this.project, loc, PullRepositorySynchronizeOperation.this.update);
                        PullRepositorySynchronizeOperation.this.project.refreshLocal(2, moni);
                    }
                }
                catch (HgException e) {
                    MercurialEclipsePlugin.logError((Throwable)((Object)e));
                    return new Status(4, "com.vectrace.MercurialEclipse", "Couldn't pull+update: " + e.getMessage(), (Throwable)((Object)e));
                }
                catch (CoreException e) {
                    MercurialEclipsePlugin.logError(e);
                    return new Status(4, "com.vectrace.MercurialEclipse", "Couldn't refresh: " + e.getMessage(), (Throwable)e);
                }
                return super.runSafe(moni);
            }
        }.schedule();
        monitor.done();
    }
}

