/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.operations;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.actions.HgOperation;
import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgPatchClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgAtticClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.operations.Messages;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IWorkbenchPart;

public class UnShelveOperation
extends HgOperation {
    private IProject project;

    public UnShelveOperation(IWorkbenchPart part, IProject p) {
        super(part);
        this.project = p;
    }

    public UnShelveOperation(IRunnableContext context, IProject p) {
        super(context);
        this.project = p;
    }

    public UnShelveOperation(IWorkbenchPart part, IRunnableContext context, IProject p) {
        super(part, context);
        this.project = p;
    }

    protected String getActionDescription() {
        return Messages.getString("UnShelveOperation.UnshelvingChanges");
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            try {
                try {
                    monitor.beginTask(Messages.getString("UnShelveOperation.Unshelving"), 4);
                    if (MercurialUtilities.isCommandAvailable("resolve", ResourceProperties.RESOLVE_AVAILABLE, "") && MercurialUtilities.isCommandAvailable("attic-shelve", ResourceProperties.EXT_HGATTIC_AVAILABLE, "")) {
                        String output = HgAtticClient.unshelve(this.project.getLocation().toFile(), false, true, this.project.getName());
                        monitor.worked(1);
                        this.project.refreshLocal(2, monitor);
                        monitor.worked(1);
                        HgClients.getConsole().printMessage(output, null);
                        break block8;
                    }
                    monitor.subTask(Messages.getString("UnShelveOperation.GettingChanges"));
                    HgRoot root = HgClients.getHgRoot(this.project.getLocation().toFile());
                    File shelveDir = new File(root, ".hg" + File.separator + "mercurialeclipse-shelve-backups");
                    if (!shelveDir.exists()) break block8;
                    File shelveFile = new File(shelveDir, this.project.getName().concat("-patchfile.patch"));
                    if (shelveFile.exists()) {
                        monitor.worked(1);
                        monitor.subTask(Messages.getString("UnShelveOperation.applyingChanges"));
                        ArrayList<String> opts = new ArrayList<String>();
                        opts.add("--no-commit");
                        HgPatchClient.importPatch(this.project, shelveFile, opts);
                        monitor.worked(1);
                        monitor.subTask(Messages.getString("UnShelveOperation.emptyingShelf"));
                        boolean deleted = shelveFile.delete();
                        monitor.worked(1);
                        monitor.subTask(Messages.getString("UnShelveOperation.refreshingProject"));
                        this.project.refreshLocal(2, monitor);
                        monitor.worked(1);
                        if (!deleted) {
                            throw new HgException(String.valueOf(shelveFile.getName()) + " could not be deleted.");
                        }
                        break block8;
                    }
                    throw new HgException(Messages.getString("UnShelveOperation.error.ShelfEmpty"));
                }
                catch (Exception e) {
                    MercurialEclipsePlugin.logError(e);
                    throw new InvocationTargetException(e, e.getLocalizedMessage());
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

