/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.commands.HgClients;
import com.vectrace.MercurialEclipse.commands.HgMergeClient;
import com.vectrace.MercurialEclipse.commands.HgResolveClient;
import com.vectrace.MercurialEclipse.commands.extensions.HgIMergeClient;
import com.vectrace.MercurialEclipse.dialogs.RevisionChooserDialog;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.menu.SingleResourceHandler;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.views.MergeView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class MergeHandler
extends SingleResourceHandler {
    protected void run(IResource resource) throws Exception {
        MergeHandler.merge(resource, this.getShell());
    }

    public static String merge(IResource resource, Shell shell) throws HgException, CoreException, PartInitException {
        IProject project = resource.getProject();
        RevisionChooserDialog dialog = new RevisionChooserDialog(shell, Messages.getString("MergeHandler.mergeWith"), project);
        String result = "";
        boolean useExternalMergeTool = Boolean.valueOf(HgClients.getPreference("hg.merge.useExternal", "false"));
        if (dialog.open() == 0) {
            boolean useResolve = MergeHandler.isHgResolveAvailable();
            result = useResolve ? HgMergeClient.merge(resource, dialog.getRevision(), useExternalMergeTool) : HgIMergeClient.merge(project, dialog.getRevision());
            project.setPersistentProperty(ResourceProperties.MERGING, dialog.getChangeSet().getChangeset());
            MergeView view = (MergeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(MergeView.ID);
            view.clearView();
            view.setCurrentProject(project);
            project.touch((IProgressMonitor)new NullProgressMonitor());
            project.refreshLocal(2, null);
        }
        return result;
    }

    private static boolean isHgResolveAvailable() throws HgException {
        return HgResolveClient.checkAvailable();
    }
}

