/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.menu;

import com.vectrace.MercurialEclipse.SafeUiJob;
import com.vectrace.MercurialEclipse.commands.HgCommitClient;
import com.vectrace.MercurialEclipse.dialogs.CommitDialog;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.menu.Messages;
import com.vectrace.MercurialEclipse.menu.SingleResourceHandler;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import com.vectrace.MercurialEclipse.team.ResourceProperties;
import com.vectrace.MercurialEclipse.team.cache.RefreshJob;
import com.vectrace.MercurialEclipse.views.MergeView;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Shell;

public class CommitMergeHandler
extends SingleResourceHandler {
    protected void run(IResource resource) throws HgException {
        Assert.isNotNull((Object)resource);
        this.commitMergeWithCommitDialog(resource, this.getShell());
    }

    public String commitMergeWithCommitDialog(IResource resource, Shell shell) throws HgException {
        Assert.isNotNull((Object)resource);
        String result = "";
        try {
            ArrayList<IResource> selectedResource = new ArrayList<IResource>(1);
            selectedResource.add(resource);
            HgRoot root = MercurialTeamProvider.getHgRoot(resource);
            CommitDialog commitDialog = new CommitDialog(shell, root, selectedResource, String.valueOf(Messages.getString("CommitMergeHandler.mergeWith")) + resource.getProject().getPersistentProperty(ResourceProperties.MERGING), false);
            commitDialog.open();
        }
        catch (CoreException e) {
            throw new HgException(Messages.getString("CommitMergeHandler.failedToSetMergeStatus"), e);
        }
        return result;
    }

    public static String commitMerge(IResource resource) throws HgException, CoreException {
        Assert.isNotNull((Object)resource);
        IProject project = resource.getProject();
        Assert.isNotNull((Object)project);
        return CommitMergeHandler.commitMerge(resource, String.valueOf(Messages.getString("CommitMergeHandler.mergeWith")) + project.getPersistentProperty(ResourceProperties.MERGING));
    }

    public static String commitMerge(IResource resource, String message) throws HgException, CoreException {
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)message);
        IProject project = resource.getProject();
        Assert.isNotNull((Object)resource.getProject());
        String result = HgCommitClient.commitProject(project, null, message);
        project.setPersistentProperty(ResourceProperties.MERGING, null);
        project.setSessionProperty(ResourceProperties.MERGE_COMMIT_OFFERED, null);
        new RefreshJob(Messages.getString("CommitMergeHandler.refreshStatusAndChangesetsAfterMergeCommit"), null, project).schedule();
        project.touch(null);
        new SafeUiJob(Messages.getString("CommitMergeHandler.clearingMergeView")){

            protected IStatus runSafe(IProgressMonitor monitor) {
                MergeView.getView().clearView();
                return super.runSafe(monitor);
            }
        }.schedule();
        return result;
    }
}

