/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.dialogs;

import com.vectrace.MercurialEclipse.dialogs.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IgnoreDialog
extends Dialog {
    private ResultType resultType;
    private IFile file;
    private IFolder folder;
    Text patternText;
    private String pattern;

    public IgnoreDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public IgnoreDialog(Shell parentShell, IFile file) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.file = file;
    }

    public IgnoreDialog(Shell parentShell, IFolder folder) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.folder = folder;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("IgnoreDialog.shell.text"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("IgnoreDialog.selectLabel.text"));
        if (this.file != null) {
            this.addButton(composite, String.valueOf(Messages.getString("IgnoreDialog.onlyFileBtn.label")) + this.file.getName() + "')", false, ResultType.FILE);
            if (this.file.getFileExtension() != null) {
                this.addButton(composite, String.valueOf(Messages.getString("IgnoreDialog.filesWithExtBtn.label")) + this.file.getFileExtension() + "')", false, ResultType.EXTENSION);
            }
        }
        if (this.folder != null) {
            this.addButton(composite, String.valueOf(Messages.getString("IgnoreDialog.folderBtn.label")) + this.folder.getName() + "')", false, ResultType.FOLDER);
        }
        this.addButton(composite, Messages.getString("IgnoreDialog.customRegExpBtn.label"), true, ResultType.REGEXP);
        this.addButton(composite, Messages.getString("IgnoreDialog.customGlobBtn.label"), true, ResultType.GLOB);
        this.patternText = new Text(composite, 2052);
        this.patternText.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private void addButton(Composite parent, String text, final boolean isPattern, final ResultType type) {
        Button button = new Button(parent, 16);
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnoreDialog.this.patternText.setEnabled(isPattern);
                IgnoreDialog.this.resultType = type;
            }
        });
    }

    protected void okPressed() {
        this.pattern = this.patternText.getText();
        super.okPressed();
    }

    public IFile getFile() {
        return this.file;
    }

    public IFolder getFolder() {
        return this.folder;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        FILE,
        FOLDER,
        EXTENSION,
        GLOB,
        REGEXP;

    }
}

