/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands.extensions;

import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.GChangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgGLogClient
extends HgCommand {
    private List<GChangeSet> sets = new ArrayList<GChangeSet>();

    public HgGLogClient(IResource resource) throws HgException {
        super("glog", resource instanceof IFile ? resource.getParent() : (IContainer)resource, false);
        this.addOptions("--config", "extensions.graphlog=");
        this.addOptions("--template", "*{rev}\\n");
        if (resource.getType() != 4) {
            this.addOptions(resource.getName());
        }
        this.setUsePreferenceTimeout("hg.timeout.log");
        this.load(this.executeToString());
    }

    protected HgGLogClient(String text) {
        super("", true);
        this.load(text);
    }

    public void load(String s) {
        String[] split = s.split("\n");
        int length = split.length / 2;
        int lengthp1 = length + 1;
        GChangeSet.RowCount rowCount = new GChangeSet.RowCount();
        GChangeSet last = null;
        int i = 0;
        while (i < lengthp1) {
            int changeset = i * 2;
            last = new GChangeSet(rowCount, i, split[changeset], i != length ? split[changeset + 1] : "").clean(last);
            this.sets.add(last);
            ++i;
        }
    }

    public List<GChangeSet> getChangeSets() {
        return this.sets;
    }

    public HgGLogClient update(Collection<ChangeSet> changeSets) {
        int diff = changeSets.size() - this.sets.size();
        if (diff > 0) {
            this.sets.addAll(Collections.nCopies(diff, null));
        }
        return this;
    }
}

