/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class HgMergeClient
extends AbstractClient {
    public static String merge(IResource res, String revision, boolean useExternalMergeTool) throws HgException {
        HgCommand command = new HgCommand("merge", HgMergeClient.getWorkingDirectory(res), false);
        command.setUsePreferenceTimeout("hg.timeout.imerge");
        if (!useExternalMergeTool) {
            command.addOptions("--config", "ui.merge=simplemerge");
        }
        if (revision != null) {
            command.addOptions("-r", revision);
        }
        try {
            String result = command.executeToString();
            return result;
        }
        catch (HgException e) {
            if (!e.getMessage().startsWith("Process error, return code: 1")) {
                throw new HgException((CoreException)((Object)e));
            }
            return e.getMessage();
        }
    }
}

