/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.FileStatus;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractParseChangesetClient
extends AbstractClient {
    private static final String STYLE_SRC = "/styles/log_style";
    private static final String STYLE = "/log_style";
    private static final String STYLE_WITH_FILES_SRC = "/styles/log_style_with_files";
    private static final String STYLE_WITH_FILES = "/log_style_with_files";
    private static final String STYLE_TEMP_EXTN = ".tmpl";
    private static ContentHandler handler;

    AbstractParseChangesetClient() {
    }

    protected static File getStyleFile(boolean withFiles) throws HgException {
        String style_src;
        String style;
        if (!withFiles) {
            style = STYLE;
            style_src = STYLE_SRC;
        } else {
            style = STYLE_WITH_FILES;
            style_src = STYLE_WITH_FILES_SRC;
        }
        String style_tmpl = String.valueOf(style) + STYLE_TEMP_EXTN;
        String style_tmpl_src = String.valueOf(style_src) + STYLE_TEMP_EXTN;
        IPath sl = MercurialEclipsePlugin.getDefault().getStateLocation();
        File stylefile = sl.append(style).toFile();
        File tmplfile = sl.append(style_tmpl).toFile();
        ClassLoader cl = AbstractParseChangesetClient.class.getClassLoader();
        if (stylefile.canRead() && tmplfile.canRead()) {
            stylefile.deleteOnExit();
            tmplfile.deleteOnExit();
            return stylefile;
        }
        InputStream styleistr = cl.getResourceAsStream(style_src);
        InputStream tmplistr = cl.getResourceAsStream(style_tmpl_src);
        try {
            int n;
            FileOutputStream styleostr = new FileOutputStream(stylefile);
            FileOutputStream tmplostr = new FileOutputStream(tmplfile);
            tmplfile.deleteOnExit();
            byte[] buffer = new byte[1024];
            while ((n = styleistr.read(buffer)) != -1) {
                ((OutputStream)styleostr).write(buffer, 0, n);
            }
            while ((n = tmplistr.read(buffer)) != -1) {
                ((OutputStream)tmplostr).write(buffer, 0, n);
            }
            ((OutputStream)styleostr).close();
            ((OutputStream)tmplostr).close();
            return stylefile;
        }
        catch (IOException e) {
            throw new HgException("Failed to setup hg style file", e);
        }
    }

    protected static final Map<IPath, SortedSet<ChangeSet>> createMercurialRevisions(IResource res, String input, boolean withFiles, ChangeSet.Direction direction, HgRepositoryLocation repository, File bundleFile, IFilePatch[] patches) throws HgException {
        HashMap<IPath, SortedSet<ChangeSet>> fileRevisions = new HashMap<IPath, SortedSet<ChangeSet>>();
        if (input == null || input.length() == 0) {
            return fileRevisions;
        }
        HgRoot hgRoot = MercurialTeamProvider.getHgRoot(res);
        String myInput = "<top>" + input + "</top>";
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(AbstractParseChangesetClient.getHandler(res, direction, repository, bundleFile, hgRoot, fileRevisions, patches));
            reader.parse(new InputSource(new StringReader(myInput)));
        }
        catch (Exception e) {
            String nextTry = AbstractParseChangesetClient.cleanControlChars(myInput);
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(AbstractParseChangesetClient.getHandler(res, direction, repository, bundleFile, hgRoot, fileRevisions, patches));
                reader.parse(new InputSource(new StringReader(nextTry)));
            }
            catch (Exception e1) {
                throw new HgException(e1.getLocalizedMessage(), e);
            }
        }
        return fileRevisions;
    }

    private static ContentHandler getHandler(IResource res, ChangeSet.Direction direction, HgRepositoryLocation repository, File bundleFile, File hgRoot, Map<IPath, SortedSet<ChangeSet>> fileRevisions, IFilePatch[] patches) {
        handler = new ChangesetContentHandler(res, direction, repository, bundleFile, hgRoot, fileRevisions, patches);
        return handler;
    }

    private static String cleanControlChars(String str) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        int i = 0;
        while (i < len) {
            int ch = str.codePointAt(i);
            if (ch == 13 || ch == 10 || ch == 9) {
                buf.appendCodePoint(ch);
            } else if (Character.isISOControl(ch)) {
                buf.append(' ');
            } else if (ch == 38) {
                buf.append("&amp;");
            } else {
                buf.appendCodePoint(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangesetContentHandler
    implements ContentHandler {
        private String br;
        private String tg;
        private int rv;
        private String ns;
        private String nl;
        private String di;
        private String da;
        private String au;
        private String pr;
        private String de;
        private StringBuilder chars;
        private static IResource res;
        private ChangeSet.Direction direction;
        private HgRepositoryLocation repository;
        private File bundleFile;
        private File hgRoot;
        private Map<IPath, SortedSet<ChangeSet>> fileRevisions;
        private Set<String> filesModified = new TreeSet<String>();
        private Set<String> filesAdded = new TreeSet<String>();
        private Set<String> filesRemoved = new TreeSet<String>();
        private FileStatus.Action action;
        private final IFilePatch[] patches;

        public ChangesetContentHandler(IResource res, ChangeSet.Direction direction, HgRepositoryLocation repository, File bundleFile, File hgRoot, Map<IPath, SortedSet<ChangeSet>> fileRevisions, IFilePatch[] patches) {
            ChangesetContentHandler.res = res;
            this.direction = direction;
            this.repository = repository;
            this.bundleFile = bundleFile;
            this.hgRoot = hgRoot;
            this.fileRevisions = fileRevisions;
            this.patches = patches;
        }

        private String unescape(String string) {
            return string.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&");
        }

        private String untab(String string) {
            return string.replaceAll("\n\t", "\n");
        }

        private String[] splitClean(String string, String sep) {
            if (string == null || string.length() == 0) {
                return new String[0];
            }
            return string.split(sep);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            int i = start;
            while (i < start + length) {
                this.chars.append(ch[i]);
                ++i;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("de")) {
                this.de = this.chars.toString();
            } else if (name.equals("cs")) {
                ChangeSet.Builder csb = new ChangeSet.Builder(this.rv, this.nl, this.br, this.di, this.unescape(this.au));
                csb.tag(this.tg);
                csb.nodeShort(this.ns);
                csb.ageDate(this.da);
                csb.description(this.untab(this.unescape(this.de)));
                csb.parents(this.splitClean(this.pr, " "));
                csb.hgRoot(this.hgRoot).bundleFile(this.bundleFile).repository(this.repository).direction(this.direction);
                csb.bundleFile(this.bundleFile);
                csb.direction(this.direction);
                csb.hgRoot(this.hgRoot);
                csb.repository(this.repository);
                csb.patches(this.patches);
                ArrayList<FileStatus> list = new ArrayList<FileStatus>();
                for (String file : this.filesModified) {
                    list.add(new FileStatus(FileStatus.Action.MODIFIED, file));
                }
                for (String file : this.filesAdded) {
                    list.add(new FileStatus(FileStatus.Action.ADDED, file));
                }
                for (String file : this.filesRemoved) {
                    list.add(new FileStatus(FileStatus.Action.REMOVED, file));
                }
                csb.changedFiles(list.toArray(new FileStatus[list.size()]));
                ChangeSet changeSet = csb.build();
                try {
                    this.addChangesetToResourceMap(changeSet);
                }
                catch (HgException e) {
                    throw new SAXException((Exception)((Object)e));
                }
                this.filesModified.clear();
                this.filesAdded.clear();
                this.filesRemoved.clear();
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.chars = new StringBuilder();
            if (name.equals("br")) {
                this.br = atts.getValue(0);
            } else if (name.equals("tg")) {
                this.tg = atts.getValue(0);
            } else if (name.equals("rv")) {
                this.rv = Integer.parseInt(atts.getValue(0));
            } else if (name.equals("ns")) {
                this.ns = atts.getValue(0);
            } else if (name.equals("nl")) {
                this.nl = atts.getValue(0);
            } else if (name.equals("di")) {
                this.di = atts.getValue(0);
            } else if (name.equals("da")) {
                this.da = atts.getValue(0);
            } else if (name.equals("au")) {
                this.au = atts.getValue(0);
            } else if (name.equals("pr")) {
                this.pr = atts.getValue(0);
            } else if (name.equals("fl")) {
                this.action = FileStatus.Action.MODIFIED;
            } else if (name.equals("fa")) {
                this.action = FileStatus.Action.ADDED;
            } else if (name.equals("fd")) {
                this.action = FileStatus.Action.REMOVED;
            } else if (name.equals("f")) {
                if (this.action == FileStatus.Action.ADDED) {
                    this.filesAdded.add(atts.getValue(0));
                    this.filesModified.remove(atts.getValue(0));
                } else if (this.action == FileStatus.Action.MODIFIED) {
                    this.filesModified.add(atts.getValue(0));
                } else if (this.action == FileStatus.Action.REMOVED) {
                    this.filesRemoved.add(atts.getValue(0));
                    this.filesModified.remove(atts.getValue(0));
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        private final void addChangesetToResourceMap(ChangeSet cs) throws HgException {
            try {
                if (cs.getChangedFiles() != null) {
                    FileStatus[] fileStatusArray = cs.getChangedFiles();
                    int n = fileStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileStatus file = fileStatusArray[n2];
                        Path root = new Path(cs.getHgRoot().getCanonicalPath());
                        Path fileRelPath = new Path(file.getPath());
                        IPath fileAbsPath = root.append((IPath)fileRelPath);
                        SortedSet<ChangeSet> revs = this.addChangeSetRevisions(cs, fileAbsPath);
                        this.fileRevisions.put(fileAbsPath, revs);
                        ++n2;
                    }
                }
                Path repoPath = new Path(cs.getHgRoot().getCanonicalPath());
                SortedSet<ChangeSet> projectRevs = this.addChangeSetRevisions(cs, (IPath)repoPath);
                this.fileRevisions.put((IPath)repoPath, projectRevs);
                IPath path = res.getLocation();
                SortedSet<ChangeSet> pathRevs = this.addChangeSetRevisions(cs, path);
                this.fileRevisions.put(path, pathRevs);
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
                throw new HgException(e.getLocalizedMessage(), e);
            }
        }

        private SortedSet<ChangeSet> addChangeSetRevisions(ChangeSet cs, IPath path) {
            SortedSet<ChangeSet> fileRevs = this.fileRevisions.get(path);
            if (fileRevs == null) {
                fileRevs = new TreeSet<ChangeSet>();
            }
            fileRevs.add(cs);
            return fileRevs;
        }
    }
}

