/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractShellCommand;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.commands.HgRootClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClient {
    protected static File getWorkingDirectory(IResource resource) {
        Assert.isNotNull((Object)resource);
        IResource myWorkDir = resource;
        if (resource.getType() == 1) {
            myWorkDir = resource.getParent();
        }
        return myWorkDir.getLocation().toFile();
    }

    protected static File getWorkingDirectory(IPath path) {
        Assert.isNotNull((Object)path);
        if (path.toFile().isFile()) {
            return path.toFile().getParentFile();
        }
        return path.toFile();
    }

    protected static File getWorkingDirectory(File file) {
        if (file.isFile()) {
            return file.getParentFile();
        }
        return file;
    }

    public static File getHgRoot(IResource res) throws HgException {
        Assert.isNotNull((Object)res);
        return HgRootClient.getHgRootAsFile(res);
    }

    public static File getHgRoot(IPath path) throws HgException {
        Assert.isNotNull((Object)path);
        File file = HgRootClient.getHgRoot(path.toFile());
        return file;
    }

    public static File getHgRoot(File file) throws HgException {
        File root = HgRootClient.getHgRoot(file);
        return root;
    }

    static List<File> toFiles(List<IResource> files) {
        ArrayList<File> toFiles = new ArrayList<File>();
        for (IResource r : files) {
            toFiles.add(r.getLocation().toFile());
        }
        return toFiles;
    }

    static List<String> toPaths(List<File> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File f : files) {
            paths.add(f.getAbsolutePath());
        }
        return paths;
    }

    public static boolean isCommandAvailable(String commandName, String extensionEnabler) {
        boolean returnValue = false;
        HgCommand command = new HgCommand("help", (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false);
        if (extensionEnabler != null && extensionEnabler.length() != 0) {
            command.addOptions("--config", "extensions." + extensionEnabler);
        }
        command.addOptions(commandName);
        try {
            String result = new String(command.executeToBytes(10000, false));
            returnValue = !result.startsWith("hg: unknown command");
        }
        catch (HgException hgException) {
            returnValue = false;
        }
        return returnValue;
    }

    protected static void addRepoToHgCommand(HgRepositoryLocation repo, AbstractShellCommand cmd) {
        URI uri = repo.getUri();
        if (uri != null) {
            cmd.addOptions(uri.toASCIIString());
        } else {
            cmd.addOptions(repo.getLocation());
        }
    }
}

