/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.ServerSocketFactory;
import com.jcraft.jsch.Session;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

class PortWatcher
implements Runnable {
    private static Vector pool = new Vector();
    private static InetAddress anyLocalAddress = null;
    Session session;
    int lport;
    int rport;
    String host;
    InetAddress boundaddress;
    Runnable thread;
    ServerSocket ss;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        Vector<String> foo = new Vector<String>();
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                PortWatcher p = (PortWatcher)pool.elementAt(i);
                if (p.session == session) {
                    foo.addElement(p.lport + ":" + p.host + ":" + p.rport);
                }
                ++i;
            }
        }
        String[] bar = new String[foo.size()];
        int i = 0;
        while (i < foo.size()) {
            bar[i] = (String)foo.elementAt(i);
            ++i;
        }
        return bar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PortWatcher getPort(Session session, String address, int lport) throws JSchException {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(address);
        }
        catch (UnknownHostException uhe) {
            throw new JSchException("PortForwardingL: invalid address " + address + " specified.", uhe);
        }
        Vector vector = pool;
        synchronized (vector) {
            int i = 0;
            while (i < pool.size()) {
                PortWatcher p = (PortWatcher)pool.elementAt(i);
                if (p.session == session && p.lport == lport) {
                    if (anyLocalAddress != null) {
                        if (p.boundaddress.equals(anyLocalAddress)) return p;
                    }
                    if (p.boundaddress.equals(addr)) {
                        return p;
                    }
                }
                ++i;
            }
            return null;
        }
    }

    static PortWatcher addPort(Session session, String address, int lport, String host, int rport, ServerSocketFactory ssf) throws JSchException {
        if (PortWatcher.getPort(session, address, lport) != null) {
            throw new JSchException("PortForwardingL: local port " + address + ":" + lport + " is already registered.");
        }
        PortWatcher pw = new PortWatcher(session, address, lport, host, rport, ssf);
        pool.addElement(pw);
        return pw;
    }

    static void delPort(Session session, String address, int lport) throws JSchException {
        PortWatcher pw = PortWatcher.getPort(session, address, lport);
        if (pw == null) {
            throw new JSchException("PortForwardingL: local port " + address + ":" + lport + " is not registered.");
        }
        pw.delete();
        pool.removeElement(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        Vector vector = pool;
        synchronized (vector) {
            PortWatcher[] foo = new PortWatcher[pool.size()];
            int count = 0;
            int i = 0;
            while (i < pool.size()) {
                PortWatcher p = (PortWatcher)pool.elementAt(i);
                if (p.session == session) {
                    p.delete();
                    foo[count++] = p;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < count) {
                PortWatcher p = foo[i2];
                pool.removeElement(p);
                ++i2;
            }
        }
    }

    PortWatcher(Session session, String address, int lport, String host, int rport, ServerSocketFactory factory) throws JSchException {
        int assigned;
        this.session = session;
        this.lport = lport;
        this.host = host;
        this.rport = rport;
        try {
            this.boundaddress = InetAddress.getByName(address);
            this.ss = factory == null ? new ServerSocket(lport, 0, this.boundaddress) : factory.createServerSocket(lport, 0, this.boundaddress);
        }
        catch (Exception e) {
            String message = "PortForwardingL: local port " + address + ":" + lport + " cannot be bound.";
            if (e instanceof Throwable) {
                throw new JSchException(message, e);
            }
            throw new JSchException(message);
        }
        if (lport == 0 && (assigned = this.ss.getLocalPort()) != -1) {
            this.lport = assigned;
        }
    }

    public void run() {
        this.thread = this;
        try {
            while (this.thread != null) {
                Socket socket = this.ss.accept();
                socket.setTcpNoDelay(true);
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                ChannelDirectTCPIP channel = new ChannelDirectTCPIP();
                channel.init();
                channel.setInputStream(in);
                channel.setOutputStream(out);
                this.session.addChannel(channel);
                channel.setHost(this.host);
                channel.setPort(this.rport);
                channel.setOrgIPAddress(socket.getInetAddress().getHostAddress());
                channel.setOrgPort(socket.getPort());
                channel.connect();
                if (channel.exitstatus == -1) continue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.delete();
    }

    void delete() {
        this.thread = null;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
            this.ss = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            anyLocalAddress = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

