/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.apt.core.internal.env.APTProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnvUtil {
    EnvUtil() {
    }

    static void updateProblemLength(List<APTProblem> problems, CompilationUnit astUnit) {
        block9: {
            int count = 0;
            int[] classNameRange = null;
            for (IProblem iProblem : problems) {
                if (iProblem.getSourceStart() < 0) {
                    if (classNameRange == null) {
                        classNameRange = EnvUtil.getClassNameRange(astUnit);
                    }
                    iProblem.setSourceStart(classNameRange[0]);
                    iProblem.setSourceEnd(classNameRange[1]);
                    iProblem.setSourceLineNumber(classNameRange[2]);
                }
                if (iProblem.getSourceEnd() >= 0) continue;
                ++count;
            }
            if (count <= 0) break block9;
            if (astUnit != null) {
                int[] nArray = new int[count];
                int index = 0;
                for (IProblem iProblem : problems) {
                    if (iProblem.getSourceEnd() >= 0) continue;
                    nArray[index++] = iProblem.getSourceStart();
                }
                EndingOffsetFinder endingOffsetFinder = new EndingOffsetFinder(nArray);
                astUnit.accept((ASTVisitor)endingOffsetFinder);
                for (IProblem iProblem : problems) {
                    if (iProblem.getSourceEnd() >= 0) continue;
                    int startingOffset = iProblem.getSourceStart();
                    int endingOffset = endingOffsetFinder.getEndingOffset(startingOffset);
                    if (endingOffset == 0) {
                        endingOffset = startingOffset;
                    }
                    iProblem.setSourceEnd(endingOffset - 1);
                }
            } else {
                for (IProblem iProblem : problems) {
                    if (iProblem.getSourceEnd() >= iProblem.getSourceStart()) continue;
                    iProblem.setSourceEnd(iProblem.getSourceStart());
                }
            }
        }
    }

    private static int[] getClassNameRange(CompilationUnit astUnit) {
        List topTypes;
        int[] startAndEnd = null;
        if (astUnit != null && (topTypes = astUnit.types()) != null && topTypes.size() > 0) {
            AbstractTypeDeclaration topType = (AbstractTypeDeclaration)topTypes.get(0);
            startAndEnd = new int[3];
            SimpleName typename = topType.getName();
            if (typename != null) {
                startAndEnd[0] = typename.getStartPosition();
                startAndEnd[1] = startAndEnd[0] + typename.getLength() - 1;
                startAndEnd[2] = astUnit.getLineNumber(typename.getStartPosition());
                if (startAndEnd[2] < 1) {
                    startAndEnd[2] = 1;
                }
            } else {
                startAndEnd[0] = topType.getStartPosition();
                startAndEnd[1] = -2;
                startAndEnd[2] = astUnit.getLineNumber(topType.getStartPosition());
                if (startAndEnd[2] < 1) {
                    startAndEnd[2] = 1;
                }
            }
        }
        if (startAndEnd == null) {
            int[] nArray = new int[3];
            nArray[1] = -2;
            nArray[2] = 1;
            return nArray;
        }
        return startAndEnd;
    }

    private static class EndingOffsetFinder
    extends ASTVisitor {
        private final int[] _sortedStartingOffset;
        private final int[] _endingOffsets;

        private EndingOffsetFinder(int[] offsets) {
            if (offsets == null) {
                throw new IllegalArgumentException("argument cannot be null.");
            }
            Arrays.sort(offsets);
            int count = 0;
            int i = 0;
            int len = offsets.length;
            while (i < len) {
                if (i <= 0 || offsets[i - 1] != offsets[i]) {
                    ++count;
                }
                ++i;
            }
            if (count != offsets.length) {
                this._sortedStartingOffset = new int[count];
                int index = 0;
                int i2 = 0;
                int len2 = offsets.length;
                while (i2 < len2) {
                    if (i2 <= 0 || offsets[i2 - 1] != offsets[i2]) {
                        this._sortedStartingOffset[index++] = offsets[i2];
                    }
                    ++i2;
                }
            } else {
                this._sortedStartingOffset = offsets;
            }
            this._endingOffsets = new int[count];
            i = 0;
            while (i < count) {
                this._endingOffsets[i] = 0;
                ++i;
            }
        }

        public void preVisit(ASTNode node) {
            int startingOffset = node.getStartPosition();
            int endingOffset = startingOffset + node.getLength();
            int startIndex = Arrays.binarySearch(this._sortedStartingOffset, startingOffset);
            int endIndex = Arrays.binarySearch(this._sortedStartingOffset, endingOffset);
            if (startIndex < 0) {
                startIndex = -startIndex - 1;
            }
            endIndex = endIndex < 0 ? -endIndex - 1 : ++endIndex;
            if (startIndex >= this._sortedStartingOffset.length) {
                return;
            }
            int i = startIndex;
            while (i < endIndex) {
                if (this._endingOffsets[i] == 0) {
                    this._endingOffsets[i] = endingOffset;
                } else if (endingOffset < this._endingOffsets[i]) {
                    this._endingOffsets[i] = endingOffset;
                }
                ++i;
            }
        }

        public int getEndingOffset(int startingOffset) {
            int index = Arrays.binarySearch(this._sortedStartingOffset, startingOffset);
            if (index == -1) {
                return 0;
            }
            return this._endingOffsets[index];
        }
    }
}

